/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.derived;

import java.util.Optional;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.MissingTypeException;
import org.eclipse.scout.sdk.core.s.derived.IDerivedResourceInput;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;

public class DerivedResourceInputWithJdt
implements IDerivedResourceInput {
    private final org.eclipse.jdt.core.IType m_jdtType;

    public DerivedResourceInputWithJdt(org.eclipse.jdt.core.IType jdtType) {
        this.m_jdtType = (org.eclipse.jdt.core.IType)Ensure.notNull((Object)jdtType);
    }

    public Optional<IType> getSourceType(IEnvironment env) {
        return DerivedResourceInputWithJdt.toScoutType(this.m_jdtType, env);
    }

    protected static Optional<IType> toScoutType(org.eclipse.jdt.core.IType jdtType, IEnvironment env) {
        try {
            return Optional.ofNullable(EclipseEnvironment.narrow(env).toScoutType(jdtType));
        }
        catch (MissingTypeException e) {
            SdkLog.info((CharSequence)"Unable to update DTO for '{}' because there are compile errors in the compilation unit.", (Object[])new Object[]{jdtType.getFullyQualifiedName(), e});
            return Optional.empty();
        }
    }

    public Optional<IClasspathEntry> getSourceFolderOf(IType type, IEnvironment env) {
        return Optional.ofNullable(type).map(EclipseEnvironment::toJdtType).map(JdtUtils::getSourceFolder).map(root -> EclipseEnvironment.narrow(env).toScoutSourceFolder((IPackageFragmentRoot)root));
    }

    public String toString() {
        return this.m_jdtType.getFullyQualifiedName();
    }

    public final int hashCode() {
        return this.m_jdtType.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DerivedResourceInputWithJdt other = (DerivedResourceInputWithJdt)obj;
        return this.m_jdtType.equals(other.m_jdtType);
    }
}

