/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.attachment;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.constants.ContainerType;
import org.eclipse.set.model.planpro.Basisobjekte.Anhang;
import org.eclipse.set.model.planpro.PlanPro.Container_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentModelProvider {
    private static final Logger logger = LoggerFactory.getLogger(AttachmentModelProvider.class);
    private final List<Anhang> domainAttachmentsFinal;
    private final List<Anhang> domainAttachmentsInitial;
    private final List<Anhang> domainAttachmentsSingle;
    private final List<Anhang> objectManagementAttachments = new ArrayList<Anhang>();

    public AttachmentModelProvider(IModelSession session) {
        this.domainAttachmentsInitial = new ArrayList<Anhang>();
        this.domainAttachmentsFinal = new ArrayList<Anhang>();
        this.domainAttachmentsSingle = new ArrayList<Anhang>();
        MultiContainer_AttributeGroup initialContainer = session.getContainer(ContainerType.INITIAL);
        MultiContainer_AttributeGroup finalContainer = session.getContainer(ContainerType.FINAL);
        MultiContainer_AttributeGroup singleContainer = session.getContainer(ContainerType.SINGLE);
        TreeIterator allContents = session.getPlanProSchnittstelle().eAllContents();
        EObject eObject = (EObject)allContents.next();
        while (allContents.hasNext()) {
            if (eObject instanceof Anhang) {
                Anhang attachment = (Anhang)eObject;
                EObject parent = attachment.eContainer();
                if (parent instanceof Container_AttributeGroup) {
                    if (initialContainer != null && Iterables.contains((Iterable)initialContainer.getContainers(), (Object)parent)) {
                        AttachmentModelProvider.addAttachment(this.domainAttachmentsInitial, attachment);
                    } else if (finalContainer != null && Iterables.contains((Iterable)finalContainer.getContainers(), (Object)parent)) {
                        AttachmentModelProvider.addAttachment(this.domainAttachmentsFinal, attachment);
                    } else if (singleContainer != null && Iterables.contains((Iterable)singleContainer.getContainers(), (Object)parent)) {
                        AttachmentModelProvider.addAttachment(this.domainAttachmentsSingle, attachment);
                    }
                } else {
                    AttachmentModelProvider.addAttachment(this.objectManagementAttachments, attachment);
                }
            }
            eObject = (EObject)allContents.next();
        }
    }

    private static void addAttachment(List<Anhang> list, Anhang attachment) {
        try {
            if (!AttachmentModelProvider.isValidAttachment(attachment) || list.stream().anyMatch(ele -> ele.getIdentitaet().getWert().equals(attachment.getIdentitaet().getWert()))) {
                return;
            }
            list.add(attachment);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private static boolean isValidAttachment(Anhang attachment) {
        try {
            String attachmentId = attachment.getIdentitaet().getWert();
            return attachmentId != null && !attachmentId.isEmpty() && !attachmentId.isBlank();
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<Anhang> getDomainAttachmentsFinal() {
        return this.domainAttachmentsFinal;
    }

    public List<Anhang> getDomainAttachmentsInitial() {
        return this.domainAttachmentsInitial;
    }

    public List<Anhang> getDomainAttachmentsSingle() {
        return this.domainAttachmentsSingle;
    }

    public List<Anhang> getObjectManagementAttachments() {
        return this.objectManagementAttachments;
    }
}

