/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.emfforms;

import jakarta.inject.Inject;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextFactory;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewModelLoadingProperties;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererFactory;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.set.utils.BasePart;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractTabViewPart
extends BasePart {
    @Inject
    EMFFormsRendererFactory renderFactory;
    protected final Map<CTabItem, EObject> tabItemToObject = new LinkedHashMap<CTabItem, EObject>();
    protected final Map<CTabItem, Composite> tabItemToComposite = new LinkedHashMap<CTabItem, Composite>();

    protected CTabFolder createTabFolder(Composite parent) {
        final CTabFolder cTabFolder = new CTabFolder(parent, 1024);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)cTabFolder);
        cTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTabViewPart.this.itemSelected(cTabFolder.getSelection());
            }
        });
        this.createTabItem(cTabFolder);
        return cTabFolder;
    }

    protected void renderTabItem(CTabItem tabItem) throws ECPRendererException {
        if (!this.tabItemToObject.containsKey(tabItem)) {
            return;
        }
        EObject tabItemObject = this.tabItemToObject.remove(tabItem);
        VViewModelLoadingProperties properties = VViewFactory.eINSTANCE.createViewModelLoadingProperties();
        properties.addNonInheritableProperty("detail", (Object)true);
        VView view = ViewProviderHelper.getView((EObject)tabItemObject, (VViewModelProperties)properties);
        ViewModelContext viewModelContext = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)view, tabItemObject);
        AbstractSWTRenderer renderer = null;
        try {
            renderer = this.renderFactory.getRendererInstance((VElement)view, viewModelContext);
        }
        catch (EMFFormsNoRendererException e) {
            throw new RuntimeException(e);
        }
        if (renderer == null) {
            return;
        }
        SWTGridDescription gridDescription = renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
        Composite composite = this.tabItemToComposite.remove(tabItem);
        for (SWTGridCell grid : gridDescription.getGrid()) {
            Control render = renderer.render(grid, composite);
            renderer.finalizeRendering(composite);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(render);
            ScrolledComposite scrolledComposite = (ScrolledComposite)ScrolledComposite.class.cast(composite);
            scrolledComposite.setExpandHorizontal(true);
            scrolledComposite.setExpandVertical(true);
            scrolledComposite.setContent(render);
            tabItem.setControl((Control)composite);
        }
    }

    protected abstract void createTabItem(CTabFolder var1);

    protected void setDefaultSelectionTab(CTabFolder folder) {
        if (folder.getItemCount() > 0) {
            folder.setSelection(0);
            this.itemSelected(folder.getSelection());
        }
    }

    protected void itemSelected(CTabItem selection) {
        try {
            this.renderTabItem(selection);
        }
        catch (ECPRendererException e) {
            throw new RuntimeException(e);
        }
    }
}

