/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.xml;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.model.validationreport.ObjectScope;
import org.eclipse.set.model.validationreport.ObjectState;
import org.eclipse.set.utils.xml.ObjectMetadataXMLReader;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EObjectXMLFinder {
    Document document = null;

    public EObjectXMLFinder(ToolboxFile toolboxFile, Path docPath) throws XmlParseException {
        try {
            this.document = ObjectMetadataXMLReader.read(toolboxFile, docPath);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new XmlParseException("The given XML document could not be parsed", e);
        }
    }

    public Node find(EObject object) {
        if (object == null) {
            return null;
        }
        EObject parent = object.eContainer();
        EStructuralFeature feature = object.eContainingFeature();
        String name = ExtendedMetaData.INSTANCE.getName(feature);
        Node parentNode = null;
        parentNode = parent == null || parent.eContainer() == null ? this.document : this.find(parent);
        if (feature.isMany()) {
            List list = (List)object.eContainer().eGet(feature);
            return EObjectXMLFinder.getNthChildByName(parentNode, name, list.indexOf(object));
        }
        return EObjectXMLFinder.getFirstChildByName(parentNode, name);
    }

    private static Node getFirstChildByName(Node node, String name) {
        return EObjectXMLFinder.getNthChildByName(node, name, 0);
    }

    private static Node getNthChildByName(Node node, String name, int n) {
        if (node == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        Stream<Node> childrenStream = IntStream.range(0, children.getLength()).mapToObj(children::item);
        return childrenStream.filter(child -> EObjectXMLFinder.getSanetizedName(child) != null && EObjectXMLFinder.getSanetizedName(child).equals(name)).skip(n).findFirst().orElse(null);
    }

    private static String getSanetizedName(Node node) {
        return (String)IterableExtensions.lastOrNull(Arrays.asList(node.getNodeName().split(":")));
    }

    public int getLineNumber(Node node) throws LineNotFoundException {
        if (node == null) {
            throw new LineNotFoundException();
        }
        String lineNum = (String)node.getUserData("startLineNumber");
        if (lineNum == null) {
            throw new LineNotFoundException();
        }
        return Integer.parseInt(lineNum);
    }

    public String getObjectType(Node node) {
        return ObjectMetadataXMLReader.getObjectType(node);
    }

    public ObjectState getObjectState(Node node) {
        return ObjectMetadataXMLReader.getObjectState(node);
    }

    public String getAttributeName(Node node) {
        return ObjectMetadataXMLReader.getAttributeName(node);
    }

    public ObjectScope getObjectScope(Node node) {
        return ObjectMetadataXMLReader.getObjectScope(node);
    }

    public static class LineNotFoundException
    extends Exception {
        public LineNotFoundException() {
            super("No line for given EObject found");
        }
    }

    public static class XmlParseException
    extends Exception {
        public XmlParseException(String m, Throwable e) {
            super(m, e);
        }
    }
}

