/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.dialogservice;

import com.google.common.collect.Lists;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiPredicate;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.ProjectInitializationData;
import org.eclipse.set.basis.Wrapper;
import org.eclipse.set.basis.exceptions.ErrorStatus;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.basis.files.ToolboxFileFilter;
import org.eclipse.set.basis.files.ToolboxFileFilterBuilder;
import org.eclipse.set.basis.rename.RenameConfirmation;
import org.eclipse.set.core.Messages;
import org.eclipse.set.core.dialogservice.ConfirmDialog;
import org.eclipse.set.core.dialogservice.ExceptionTransformation;
import org.eclipse.set.core.dialogservice.LoadIncompleteFileDialog;
import org.eclipse.set.core.dialogservice.LoadInvalidFileDialog;
import org.eclipse.set.core.dialogservice.LoadInvalidSiteplanDialog;
import org.eclipse.set.core.dialogservice.ProjectFilenameInitialization;
import org.eclipse.set.core.dialogservice.ReportSavedSessionDialog;
import org.eclipse.set.core.dialogservice.SelectValueDialog;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.core.services.files.ToolboxFileService;
import org.eclipse.set.custom.extensions.FileDialogExtensions;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialogServiceImpl
implements DialogService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialogServiceImpl.class);
    private List<ToolboxFileFilter> csvFileFilters;
    private List<ToolboxFileFilter> dokumentFileFilters;
    private List<ToolboxFileFilter> fileFiltersForAllFiles;
    @Inject
    private ToolboxFileService fileService;
    private List<ToolboxFileFilter> imageFileFilters;
    private List<ToolboxFileFilter> modelFileFilters;
    private List<ToolboxFileFilter> planProFileFilters;
    private List<ToolboxFileFilter> xlsxFileFilters;
    @Inject
    @Translation
    Messages messages;
    @Inject
    UISynchronize sync;
    @Inject
    @Translation
    org.eclipse.set.utils.Messages utilMessages;

    public boolean confirmClose(Shell shell) {
        ConfirmDialog confirmDialog = new ConfirmDialog(shell, this.messages.WindowCloseAddon_ConfirmTitle, this.messages.WindowCloseAddon_CloseMessage, this.messages.DialogService_CloseLabel);
        return confirmDialog.confirmed();
    }

    public boolean confirmCloseUnsaved(Shell shell) {
        ConfirmDialog confirmDialog = new ConfirmDialog(shell, this.messages.WindowCloseAddon_ConfirmTitle, this.messages.WindowCloseAddon_CloseUnsavedMessage, this.messages.DialogService_CloseUnsavedLabel);
        return confirmDialog.confirmed();
    }

    public boolean confirmCreateDirectory(Shell shell, Path path) {
        ConfirmDialog confirmDialog = new ConfirmDialog(shell, this.messages.DialogService_ConfirmCreateDirectory_Title, String.format(this.messages.DialogService_ConfirmCreateDirectory_MessagePattern, path.toString()), this.messages.DialogService_ConfirmCreateDirectory_ConfirmLabel);
        return confirmDialog.confirmed();
    }

    public boolean confirmDeletion(Shell shell, Path path) {
        ConfirmDialog confirmDialog = new ConfirmDialog(shell, this.utilMessages.Dialogs_confirmDeletionTitle, String.format(this.utilMessages.Dialogs_confirmDeletionMessagePattern, path.getFileName().toString()), this.messages.DialogService_ConfirmDeleteLabel);
        Wrapper result = new Wrapper();
        Display.getDefault().syncExec(() -> result.setValue((Object)confirmDialog.confirmed()));
        return (Boolean)result.getValue();
    }

    public boolean confirmOverwrite(Shell shell, Path path) {
        ConfirmDialog confirmDialog = new ConfirmDialog(shell, this.utilMessages.Dialogs_confirmOverwriteTitle, String.format(this.utilMessages.Dialogs_confirmOverwriteMessagePattern, path.getFileName().toString()), this.utilMessages.Dialogs_confirmOverwriteLabel);
        Wrapper result = new Wrapper();
        Display.getDefault().syncExec(() -> result.setValue((Object)confirmDialog.confirmed()));
        return (Boolean)result.getValue();
    }

    public boolean confirmOverwriteOperationalData(Shell shell) {
        ConfirmDialog confirmDialog = new ConfirmDialog(shell, this.messages.DialogService_ConfirmOverwriteOperationalData_Title, this.messages.DialogService_ConfirmOverwriteOperationalData_Message, this.messages.DialogService_ConfirmOverwriteOperationalData_ConfirmLabel);
        return confirmDialog.confirmed();
    }

    public boolean confirmOverwriteUnsaved(Shell shell, String title, String mess) {
        ConfirmDialog confirmDialog = new ConfirmDialog(shell, title, mess, this.messages.DialogService_ConfirmOverwriteOperationalData_ConfirmLabel);
        return confirmDialog.confirmed();
    }

    public RenameConfirmation confirmRename(Shell shell, String oldFilename, String newFilename) {
        RenameMessageDialog messageDialog = new RenameMessageDialog(shell, this.messages.DialogService_ConfirmRename_Title, null, String.format(this.messages.DialogService_ConfirmRename_MessagePattern, oldFilename, newFilename), 5, new String[]{this.messages.DialogService_ConfirmRename_ChangeLabel, this.messages.DialogService_ConfirmRename_NewLabel, JFaceResources.getString((String)"cancel")}, 2);
        return RenameConfirmation.fromDialogResult((int)messageDialog.open());
    }

    public boolean confirmSetDefaultsManagement(Shell shell) {
        return MessageDialog.openQuestion((Shell)shell, (String)this.messages.DialogService_ConfirmFillDefaults_Title, (String)this.messages.DialogService_ConfirmFillDefaults_Label);
    }

    public String selectValueDialog(Shell shell, String title, String message, String comboLabel, List<String> selectItems) {
        SelectValueDialog dialog = new SelectValueDialog(shell, title, message, selectItems);
        dialog.open();
        Optional firstResult = dialog.getFirstResult();
        if (firstResult.isEmpty()) {
            return null;
        }
        return (String)firstResult.get();
    }

    public boolean confirmExportNotCompleteTable(Shell shell) {
        return MessageDialog.openQuestion((Shell)shell, (String)this.messages.DialogService_ConfirmExportNotCompleteTable_Title, (String)this.messages.DialogService_ConfirExportNotCompleteTable_Label);
    }

    public void error(Shell shell, Exception e) {
        LOGGER.error(e.getMessage(), (Throwable)e);
        ErrorStatus status = new ExceptionTransformation(this.messages).transform(e, null);
        this.sync.syncExec(() -> {
            int n = ErrorDialog.openError((Shell)shell, (String)status.getErrorTitle(), (String)status.getUserMessage(), (IStatus)status.getStatus());
        });
    }

    public void error(Shell shell, String message) {
        LOGGER.error(message);
        ErrorStatus status = new ExceptionTransformation(this.messages).transform(null, null);
        this.sync.syncExec(() -> {
            int n = ErrorDialog.openError((Shell)shell, (String)status.getErrorTitle(), (String)message, (IStatus)status.getStatus());
        });
    }

    public void error(Shell shell, String title, String message, Exception e) {
        LOGGER.error(e.getMessage(), (Throwable)e);
        this.sync.syncExec(() -> {
            int n = ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)new ExceptionTransformation(this.messages).transform(e, null).getStatus());
        });
    }

    public void error(Shell shell, String title, String message, String technicalMsg, Exception e) {
        LOGGER.error(e.getMessage(), (Throwable)e);
        this.sync.syncExec(() -> {
            int n = ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)new ExceptionTransformation(this.messages).transform(e, technicalMsg).getStatus());
        });
    }

    public List<ToolboxFileFilter> getCsvFileFilters() {
        return this.csvFileFilters;
    }

    public List<ToolboxFileFilter> getDokumentFileFilters() {
        return this.dokumentFileFilters;
    }

    public List<ToolboxFileFilter> getFileFiltersForAllFiles() {
        return this.fileFiltersForAllFiles;
    }

    public List<ToolboxFileFilter> getImageFileFilters() {
        return this.imageFileFilters;
    }

    public List<ToolboxFileFilter> getModelFileFilters() {
        return this.modelFileFilters;
    }

    public List<ToolboxFileFilter> getPlanProFileFilters() {
        return this.planProFileFilters;
    }

    public List<ToolboxFileFilter> getXlsxFileFilters() {
        return this.xlsxFileFilters;
    }

    public boolean loadIncompleteModel(Shell shell, String filename) {
        LoadIncompleteFileDialog validationDialog = new LoadIncompleteFileDialog(shell, this.messages, filename);
        int result = validationDialog.open();
        validationDialog.close();
        return result == 0;
    }

    public boolean loadIncompleteModel(Shell shell, String dialogTitle, String dialogMsg, String ... buttonsLabel) {
        LoadIncompleteFileDialog dialog = new LoadIncompleteFileDialog(shell, dialogTitle, dialogMsg, buttonsLabel);
        int open = dialog.open();
        dialog.close();
        return open == 0;
    }

    public boolean loadInvalidModel(Shell shell, String filename) {
        LoadInvalidFileDialog validationDialog = new LoadInvalidFileDialog(shell, this.messages, filename);
        int result = validationDialog.open();
        validationDialog.close();
        return result == 0;
    }

    public boolean loadInvalidModel(Shell shell, String dialogTitle, String dialogMsg, String ... buttonsLabel) {
        LoadInvalidFileDialog dialog = new LoadInvalidFileDialog(shell, dialogTitle, dialogMsg, buttonsLabel);
        int open = dialog.open();
        dialog.close();
        return open == 0;
    }

    public void openInformation(Shell shell, String title, String message) {
        MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
    }

    public int projectInitialization(Shell shell, BiPredicate<Shell, ProjectInitializationData> initAction) {
        ProjectFilenameInitialization dialog = new ProjectFilenameInitialization(shell, this.messages, this);
        dialog.setInitAction(initAction);
        dialog.setCreateDirectoryPermission(this::confirmCreateDirectory);
        return dialog.open();
    }

    public void reportExported(Shell shell) {
        MessageDialog.openInformation((Shell)shell, (String)this.messages.DialogService_ReportExported_Title, (String)this.messages.DialogService_ReportExported_Message);
    }

    public void reportImported(Shell shell) {
        MessageDialog.openInformation((Shell)shell, (String)this.messages.DialogService_ReportImported_Title, (String)this.messages.DialogService_ReportImported_Message);
    }

    public void reportSavedFile(Shell shell, Path path) {
        MessageDialog.openInformation((Shell)shell, (String)this.utilMessages.AttachmentTable_fileSaveSuccess, (String)String.format(this.utilMessages.AttachmentTable_fileSuccessfullySavedPattern, path.toString()));
    }

    public void reportSavedSession(Shell shell, IModelSession session) {
        ReportSavedSessionDialog dialog = new ReportSavedSessionDialog(shell, session, this.messages);
        dialog.open();
    }

    public void showDistance(Shell shell, double distance) {
        MessageDialog.openInformation((Shell)shell, (String)this.messages.DialogService_ShowDistance_Title, (String)String.format(this.messages.DialogService_ShowDistance_DistancePattern, distance));
    }

    public void showProgress(Shell shell, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        new ProgressMonitorDialog(shell).run(true, false, runnable);
    }

    public void showProgressUISync(Shell shell, String message, Runnable runnable) {
        MessageDialog dialog = new MessageDialog(shell, this.messages.DialogService_ProgressUISyncTitle, null, message, 2, new String[0], 0);
        dialog.setBlockOnOpen(false);
        dialog.open();
        this.sync.syncExec(runnable);
        dialog.close();
    }

    public <T> T showProgressUISync(Shell shell, String message, Callable<T> callAble) throws InterruptedException, ExecutionException {
        MessageDialog dialog = new MessageDialog(shell, this.messages.DialogService_ProgressUISyncTitle, null, message, 2, new String[0], 0);
        dialog.setBlockOnOpen(false);
        dialog.open();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ExecutorService executor = Executors.newSingleThreadExecutor();){
                Future<T> future = executor.submit(callAble);
                T t = future.get(120L, TimeUnit.SECONDS);
                dialog.close();
                return t;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (TimeoutException e) {
            throw new ExecutionException(e);
        }
    }

    @PostConstruct
    private void postConstruct() {
        this.modelFileFilters = Lists.newLinkedList();
        this.modelFileFilters.add(ToolboxFileFilterBuilder.forName((String)this.messages.DialogService_ModelFilterName).add((Iterable)this.fileService.extensionsForCategory("ppfile")).filterNameWithFilterList(true).create());
        this.planProFileFilters = Lists.newLinkedList();
        this.planProFileFilters.add(ToolboxFileFilterBuilder.forName((String)this.messages.DialogService_PlanProFilterName).add((Iterable)this.fileService.extensionsForCategory("ppall")).filterNameWithFilterList(true).create());
        this.planProFileFilters.add(ToolboxFileFilterBuilder.forName((String)this.messages.DialogService_ModelFilterName).add((Iterable)this.fileService.extensionsForCategory("ppfile")).filterNameWithFilterList(true).create());
        this.planProFileFilters.add(ToolboxFileFilterBuilder.forName((String)this.messages.DialogService_MergeFilterName).add((Iterable)this.fileService.extensionsForCategory("ppmerge")).filterNameWithFilterList(true).create());
        this.csvFileFilters = Lists.newLinkedList();
        this.csvFileFilters.add(ToolboxFileFilterBuilder.forName((String)this.messages.DialogService_CsvFilterName).add((Iterable)PathExtensions.CSV_FILE_EXTENSIONS).filterNameWithFilterList(true).create());
        this.imageFileFilters = Lists.newLinkedList();
        this.imageFileFilters.add(ToolboxFileFilterBuilder.forName((String)this.messages.DialogService_ImagesFilterName).add((Iterable)PathExtensions.IMAGE_FILE_EXTENSIONS).filterNameWithFilterList(true).create());
        this.dokumentFileFilters = Lists.newLinkedList();
        this.dokumentFileFilters.add(ToolboxFileFilterBuilder.forName((String)this.messages.DialogService_DokumentFilterName).add((Iterable)PathExtensions.DOKUMENT_FILE_EXTENSIONS).filterNameWithFilterList(true).create());
        this.xlsxFileFilters = Lists.newLinkedList();
        this.xlsxFileFilters.add(ToolboxFileFilterBuilder.forName((String)this.messages.DialogService_XlsxFilterName).add((Iterable)PathExtensions.EXCEL_FILE_EXTENSION).filterNameWithFilterList(true).create());
        this.fileFiltersForAllFiles = Lists.newLinkedList();
        this.fileFiltersForAllFiles.add(ToolboxFileFilterBuilder.forName((String)this.messages.DialogService_FilterForAllFiles).add((Iterable)PathExtensions.ALL_FILE_EXTENSION).filterNameWithFilterList(true).create());
    }

    protected String getPlanningDescription(boolean isPrimaryValid, boolean isSecondaryValid) {
        if (!isPrimaryValid && !isSecondaryValid) {
            return this.messages.DialogService_PlanningDescriptionPrimaryAndSecondary;
        }
        if (!isPrimaryValid) {
            return this.messages.DialogService_PlanningDescriptionPrimary;
        }
        if (!isSecondaryValid) {
            return this.messages.DialogService_PlanningDescriptionSecondary;
        }
        throw new IllegalArgumentException("isPrimaryValid=" + isPrimaryValid + " isSecondaryValid=" + isSecondaryValid);
    }

    private static Optional<Path> selectFile(int style, Shell shell, List<ToolboxFileFilter> filters, Optional<Path> defaultPath, Optional<String> title) {
        FileDialog fileDialog = new FileDialog(shell, style);
        title.ifPresent(arg_0 -> ((FileDialog)fileDialog).setText(arg_0));
        Optional<Path> parent = defaultPath.map(Path::getParent);
        Optional<Path> fileName = defaultPath.map(Path::getFileName);
        parent.ifPresent(p -> fileDialog.setFilterPath(p.toString()));
        fileName.ifPresent(f -> fileDialog.setFileName(f.toString()));
        fileDialog.setOverwrite(true);
        FileDialogExtensions.setExtensionFilters((FileDialog)fileDialog, filters);
        return Optional.ofNullable(fileDialog.open()).map(string -> Paths.get(string, new String[0]));
    }

    public boolean createCompositePlanningWithInvalidInput(Shell shell, boolean isPrimaryValid, boolean isSecondaryValid) {
        int result = MessageDialog.open((int)4, (Shell)shell, (String)this.messages.createCompositePlanningWithInvalidInputTitle, (String)String.format(this.messages.createCompositePlanningWithInvalidInputPattern, this.getPlanningDescription(isPrimaryValid, isSecondaryValid)), (int)0, (String[])new String[]{this.messages.DialogService_CreateCompositePlanningButton, this.messages.DialogService_ReturnButton});
        return result == 0;
    }

    public boolean doApplyAutofill(Shell shell, String date) {
        int buttonIndex = MessageDialog.open((int)3, (Shell)shell, (String)this.messages.DialogService_AutoFillConfirmation_Title, (String)String.format(this.messages.DialogService_AutoFillConfirmation_Pattern, date), (int)0, (String[])new String[]{this.messages.DialogService_AutoFillConfirmation_Button_Apply, this.messages.DialogService_AutoFillConfirmation_Button_NotApply});
        return buttonIndex == 0;
    }

    public void openDirectoryAfterExport(Shell shell, Path path) {
        int result = MessageDialog.open((int)2, (Shell)shell, (String)this.messages.DialogService_OpenDirectoryAfterExport_Title, (String)this.messages.DialogService_OpenDirectoryAfterExport_Message, (int)0, (String[])new String[]{IDialogConstants.OK_LABEL, this.messages.DialogService_OpenDirectoryAfterExport_ShowDir});
        if (result == 1) {
            try {
                Runtime.getRuntime().exec(new String[]{"explorer", path.toString()});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Optional<Path> openFileDialog(Shell shell, List<ToolboxFileFilter> filters, Optional<Path> filterPath) {
        return DialogServiceImpl.selectFile(4096, shell, filters, filterPath, Optional.empty());
    }

    public Optional<Path> saveFileDialog(Shell shell, List<ToolboxFileFilter> filters, Path defaultPath) {
        return DialogServiceImpl.selectFile(8192, shell, filters, Optional.ofNullable(defaultPath), Optional.empty());
    }

    public Optional<Path> saveFileDialog(Shell shell, List<ToolboxFileFilter> filters, Path defaultPath, String title) {
        return DialogServiceImpl.selectFile(8192, shell, filters, Optional.ofNullable(defaultPath), Optional.ofNullable(title));
    }

    public Optional<String> selectDirectory(Shell shell, String pathFilter) {
        File dirFile;
        DirectoryDialog directoryDialog = new DirectoryDialog(shell);
        directoryDialog.setFilterPath(pathFilter);
        directoryDialog.setMessage(this.messages.DialogService_SelectDirectory);
        String dir = directoryDialog.open();
        if (dir != null && !(dirFile = new File(dir)).exists()) {
            dirFile.mkdir();
        }
        return Optional.ofNullable(dir);
    }

    public boolean sitePlanError(Shell shell, String filename) {
        LoadInvalidSiteplanDialog dialog = new LoadInvalidSiteplanDialog(shell, filename, this.messages);
        int result = dialog.open();
        dialog.close();
        return result == 0;
    }

    private static class RenameMessageDialog
    extends MessageDialog {
        public RenameMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        }

        protected Point getInitialSize() {
            Point size = this.getShell().computeSize(-1, -1, true);
            size.x = (int)((double)size.x * 1.2);
            return size;
        }
    }
}

