/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation.session;

import com.google.common.base.Strings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.set.basis.Pair;
import org.eclipse.set.basis.ToolboxPaths;
import org.eclipse.set.basis.constants.ExportType;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.feature.validation.session.ModelSession;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;

public class ToolboxPathsImpl
implements ToolboxPaths {
    private final ModelSession modelSession;

    public ToolboxPathsImpl(ModelSession modelSession) {
        this.modelSession = modelSession;
    }

    public Path getTableExportPath(String shortcut, Path base, ExportType exportType, ToolboxPaths.ExportPathExtension extension) {
        LinkedList<String> pathPart = new LinkedList<String>();
        pathPart.add(this.getModelBaseName(exportType));
        pathPart.add(StringUtils.capitalize((String)shortcut));
        String areaName = this.getControlAreaName();
        if (!Strings.isNullOrEmpty((String)areaName)) {
            pathPart.add(areaName);
        }
        return Paths.get(base.toString(), String.join((CharSequence)"_", pathPart) + extension.value);
    }

    private String getModelBaseName(ExportType exportType) {
        Path derivedPath = PlanProSchnittstelleExtensions.getDerivedPath((PlanPro_Schnittstelle)this.modelSession.getPlanProSchnittstelle(), (String)"xxx", (String)"xxx", (ExportType)exportType);
        return PathExtensions.getBaseFileName((Path)derivedPath);
    }

    private String getControlAreaName() {
        List<Pair<String, String>> controlAreaIds = this.modelSession.getSelectedControlAreas();
        if (controlAreaIds.size() != 1) {
            return null;
        }
        return (String)controlAreaIds.getFirst().getFirst();
    }
}

