/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.enumtransformation.impl;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.eclipse.set.core.services.enumtranslation.EnumTranslation;
import org.eclipse.set.utils.enums.EnumTranslationUtils;

public class TranslationCode {
    private static final String COPYRIGHT_DATE_PATTERN = "uuuu";
    private static final String MESSAGE_ENTRY_PATTERN = "\t/**%n\t * %s%n\t */%n\tpublic String %s;%n%n";
    private static final String MESSAGE_FILE = "Enumerators.java";
    private static final String MESSAGES_EPILOGUE_PATTERN = "\t/**\n\t * Fehler\n\t */\n\tpublic String ERROR_Alternative;\n\n\t/**\n\t * Warnung\n\t */\n\tpublic String WARNING_Alternative;\n\n\t/**\n\t * Erfolg\n\t */\n\tpublic String SUCCESS_Alternative;\n}";
    private static final String MESSAGES_INTRODUCTION_PATTERN = "  /**\n   * Copyright (c) %s DB Netz AG and others.\n   *\n   * All rights reserved. This program and the accompanying materials\n   * are made available under the terms of the Eclipse Public License v2.0\n   * which accompanies this distribution, and is available at\n   * http://www.eclipse.org/legal/epl-v20.html\n   */\n  package org.eclipse.set.core.enumtranslation;\n\n  import org.eclipse.set.core.AbstractMessageService;\n  import org.osgi.service.component.annotations.Activate;\n  import org.osgi.service.component.annotations.Component;\n\n  /**\n   * Translations for enumerators.\n   *\n   * @generated\n   */\n  @Component(service = Enumerators.class)\n  public class Enumerators extends AbstractMessageService {\n  \t\t@Activate\n  \t\tprivate void setupLocalization()\n  \t\t\t\tthrows IllegalArgumentException, IllegalAccessException {\n  \t\t\tsuper.setupLocalization(\n  \t\t\t\t\t\"platform:/plugin/org.eclipse.set.core/translation/Enumerators\");\n  \t\t}\n";
    private static final String PROPERTIES_DATE_PATTERN = "uuuu-MM-dd";
    private static final String PROPERTIES_FILE = "Enumerators.properties";
    private static final String PROPERTIES_INTRODUCTION_PATTERN = "# generated %s%n%n";
    private static final String PROPERTIES_EPILOGUE_PATTERN = "ERROR_Alternative=Fehler\nWARNING_Alternative=Warnung\nSUCCESS_Alternative=Erfolg\n";
    private static final String PROPERTY_ENTRY_PATTERN = "%s=%s%n";
    private boolean closed = false;
    private final StringBuilder messages = new StringBuilder();
    private final StringBuilder properties = new StringBuilder();

    private static String getMessagesEpilogue() {
        return String.format(MESSAGES_EPILOGUE_PATTERN, new Object[0]);
    }

    private static String getMessagesIntroduction() {
        LocalDate now = LocalDate.now();
        return String.format(MESSAGES_INTRODUCTION_PATTERN, now.format(DateTimeFormatter.ofPattern(COPYRIGHT_DATE_PATTERN)));
    }

    private static String getPropertiesEpilogue() {
        return PROPERTIES_EPILOGUE_PATTERN;
    }

    private static String getPropertiesIntroduction() {
        LocalDate now = LocalDate.now();
        return String.format(PROPERTIES_INTRODUCTION_PATTERN, now.format(DateTimeFormatter.ofPattern(PROPERTIES_DATE_PATTERN)));
    }

    private static String nullToEmpty(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public TranslationCode() {
        this.messages.append(TranslationCode.getMessagesIntroduction());
        this.properties.append(TranslationCode.getPropertiesIntroduction());
    }

    public void add(EnumTranslation translation) {
        if (this.closed) {
            throw new IllegalStateException("translation code closed");
        }
        this.appendToMessages(translation);
        this.appendToProperties(translation);
    }

    public String getMessageFile() {
        return MESSAGE_FILE;
    }

    public String getMessages() {
        this.close();
        return this.messages.toString();
    }

    public String getProperties() {
        this.close();
        return this.properties.toString();
    }

    public String getPropertiesFile() {
        return PROPERTIES_FILE;
    }

    private void appendToMessages(EnumTranslation translation) {
        String presentation = String.format(MESSAGE_ENTRY_PATTERN, translation.getPresentation(), EnumTranslationUtils.getKeyPresentation((String)translation.getKeyBasis()));
        this.messages.append(presentation);
        String sorting = String.format(MESSAGE_ENTRY_PATTERN, translation.getSorting(), EnumTranslationUtils.getKeySorting((String)translation.getKeyBasis()));
        this.messages.append(sorting);
        String alternative = String.format(MESSAGE_ENTRY_PATTERN, translation.getAlternative(), EnumTranslationUtils.getKeyAlternative((String)translation.getKeyBasis()));
        this.messages.append(alternative);
    }

    private void appendToProperties(EnumTranslation translation) {
        String presentation = String.format(PROPERTY_ENTRY_PATTERN, EnumTranslationUtils.getKeyPresentation((String)translation.getKeyBasis()), TranslationCode.nullToEmpty(translation.getPresentation()));
        this.properties.append(presentation);
        String sorting = String.format(PROPERTY_ENTRY_PATTERN, EnumTranslationUtils.getKeySorting((String)translation.getKeyBasis()), TranslationCode.nullToEmpty(translation.getSorting()));
        this.properties.append(sorting);
        String alternative = String.format(PROPERTY_ENTRY_PATTERN, EnumTranslationUtils.getKeyAlternative((String)translation.getKeyBasis()), TranslationCode.nullToEmpty(translation.getAlternative()));
        this.properties.append(alternative);
    }

    private void close() {
        if (!this.closed) {
            this.closed = true;
            this.messages.append(TranslationCode.getMessagesEpilogue());
            this.properties.append(TranslationCode.getPropertiesEpilogue());
        }
    }
}

