/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.pt1.sskp;

import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.constants.ToolboxConstants;
import org.eclipse.set.basis.graph.TopPoint;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.core.services.graph.TopologicalGraphService;
import org.eclipse.set.feature.table.pt1.AbstractPlanPro2TableModelTransformator;
import org.eclipse.set.feature.table.pt1.sskp.SskpBahnsteigUtils;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Stell_Bereich;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Unterbringung;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Unterbringung_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Unterbringung_Befestigung_TypeClass;
import org.eclipse.set.model.planpro.Bahnsteig.Bahnsteig_Kante;
import org.eclipse.set.model.planpro.Bahnuebergang.BUE_Anlage;
import org.eclipse.set.model.planpro.BasisTypen.BasisAttribut_AttributeGroup;
import org.eclipse.set.model.planpro.BasisTypen.Bezeichnung_Element_AttributeGroup;
import org.eclipse.set.model.planpro.BasisTypen.Bezeichnung_Tabelle_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Basis_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Bearbeitungsvermerk;
import org.eclipse.set.model.planpro.Basisobjekte.Bearbeitungsvermerk_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Kurztext_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Ur_Objekt;
import org.eclipse.set.model.planpro.Fahrstrasse.Bezeichnung_Markanter_Punkt_TypeClass;
import org.eclipse.set.model.planpro.Fahrstrasse.DWeg_V_TypeClass;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_DWeg;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_DWeg_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_DWeg_Spezifisch_AttributeGroup;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Fahrweg;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Zug_Rangier;
import org.eclipse.set.model.planpro.Fahrstrasse.Markanter_Punkt;
import org.eclipse.set.model.planpro.Fahrstrasse.Markanter_Punkt_Bezeichnung_AttributeGroup;
import org.eclipse.set.model.planpro.Fahrstrasse.Massgebende_Neigung_TypeClass;
import org.eclipse.set.model.planpro.PZB.ENUMPZBArt;
import org.eclipse.set.model.planpro.PZB.ENUMWirksamkeit;
import org.eclipse.set.model.planpro.PZB.ENUMWirksamkeitFstr;
import org.eclipse.set.model.planpro.PZB.GUE_Anordnung_TypeClass;
import org.eclipse.set.model.planpro.PZB.GUE_Bauart_TypeClass;
import org.eclipse.set.model.planpro.PZB.GUE_Energieversorgung_TypeClass;
import org.eclipse.set.model.planpro.PZB.GUE_Messstrecke_TypeClass;
import org.eclipse.set.model.planpro.PZB.Messfehler_TypeClass;
import org.eclipse.set.model.planpro.PZB.PZB_Art_TypeClass;
import org.eclipse.set.model.planpro.PZB.PZB_Element;
import org.eclipse.set.model.planpro.PZB.PZB_Element_GM_AttributeGroup;
import org.eclipse.set.model.planpro.PZB.PZB_Element_GUE_AttributeGroup;
import org.eclipse.set.model.planpro.PZB.PZB_Element_Zuordnung;
import org.eclipse.set.model.planpro.PZB.PZB_Element_Zuordnung_INA_AttributeGroup;
import org.eclipse.set.model.planpro.PZB.Prioritaet_Gefahrstelle_TypeClass;
import org.eclipse.set.model.planpro.PZB.Pruefgeschwindigkeit_TypeClass;
import org.eclipse.set.model.planpro.PZB.Pruefzeit_TypeClass;
import org.eclipse.set.model.planpro.PZB.Wirksamkeit_Fstr_TypeClass;
import org.eclipse.set.model.planpro.PZB.Wirksamkeit_TypeClass;
import org.eclipse.set.model.planpro.Signalbegriffe_Ril_301.Ne5;
import org.eclipse.set.model.planpro.Signale.ENUMSignalArt;
import org.eclipse.set.model.planpro.Signale.ENUMSignalFunktion;
import org.eclipse.set.model.planpro.Signale.PZB_Schutzstrecke_Soll_TypeClass;
import org.eclipse.set.model.planpro.Signale.Signal;
import org.eclipse.set.model.planpro.Signale.Signal_Art_TypeClass;
import org.eclipse.set.model.planpro.Signale.Signal_Funktion_TypeClass;
import org.eclipse.set.model.planpro.Signale.Signal_Rahmen;
import org.eclipse.set.model.planpro.Signale.Signal_Real_Aktiv_Schirm_AttributeGroup;
import org.eclipse.set.model.planpro.Signale.Signal_Real_AttributeGroup;
import org.eclipse.set.model.planpro.Signale.Signal_Signalbegriff;
import org.eclipse.set.model.planpro.Verweise.ID_BUE_Anlage_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_BUE_Anlage_ohne_Proxy_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Bahnsteig_Kante_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Fstr_Fahrweg_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Fstr_Zug_Rangier_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Markante_Stelle_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Markanter_Punkt_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_PZB_Element_Mitnutzung_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_PZB_Element_Zuordnung_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Signal_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Unterbringung_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Gsp_Element;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Zungenpaar_AttributeGroup;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.FstrZugRangierExtensions;
import org.eclipse.set.ppmodel.extensions.PZBElementExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.ppmodel.extensions.SignalExtensions;
import org.eclipse.set.ppmodel.extensions.SignalRahmenExtensions;
import org.eclipse.set.ppmodel.extensions.SignalbegriffExtensions;
import org.eclipse.set.ppmodel.extensions.UrObjectExtensions;
import org.eclipse.set.ppmodel.extensions.WKrGspElementExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.utils.Case;
import org.eclipse.set.ppmodel.extensions.utils.IterableExtensions;
import org.eclipse.set.ppmodel.extensions.utils.TopGraph;
import org.eclipse.set.utils.math.AgateRounding;
import org.eclipse.set.utils.math.BigDecimalExtensions;
import org.eclipse.set.utils.math.BigIntegerExtensions;
import org.eclipse.set.utils.math.DoubleExtensions;
import org.eclipse.set.utils.table.AbstractTableModelTransformator;
import org.eclipse.set.utils.table.RowFactory;
import org.eclipse.set.utils.table.TMFactory;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.osgi.service.event.EventAdmin;

public class SskpTransformator
extends AbstractPlanPro2TableModelTransformator {
    private static final double ADDITION_SCHUTZSTRECKE_SOLL_60 = 450.0;
    private static final double ADDITION_SCHUTZSTRECKE_SOLL_40_60 = 350.0;
    private static final double ADDITION_SCHUTZSTRECKE_SOLL_40 = 210.0;
    private TopologicalGraphService topGraphService;

    public SskpTransformator(Set<ColumnDescriptor> cols, EnumTranslationService enumTranslationService, TopologicalGraphService topGraphService, EventAdmin eventAdmin) {
        super(cols, enumTranslationService, eventAdmin);
        this.topGraphService = topGraphService;
    }

    public Table transformTableContent(MultiContainer_AttributeGroup container, TMFactory factory, Stell_Bereich controlArea) {
        Iterable _tOPKante = container.getTOPKante();
        TopGraph topGraph = new TopGraph(_tOPKante);
        Functions.Function1 _function = it -> UrObjectExtensions.isPlanningObject((Ur_Objekt)it);
        Functions.Function1 _function_1 = it -> {
            PZB_Element_GUE_AttributeGroup _pZBElementGUE = it.getPZBElementGUE();
            ID_PZB_Element_Mitnutzung_TypeClass _iDPZBElementMitnutzung = null;
            if (_pZBElementGUE != null) {
                _iDPZBElementMitnutzung = _pZBElementGUE.getIDPZBElementMitnutzung();
            }
            PZB_Element _value = null;
            if (_iDPZBElementMitnutzung != null) {
                _value = _iDPZBElementMitnutzung.getValue();
            }
            return _value == null;
        };
        Iterable _filter = org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)UrObjectExtensions.filterObjectsInControlArea((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)container.getPZBElement(), (Functions.Function1)_function), (Stell_Bereich)controlArea), (Functions.Function1)_function_1);
        for (PZB_Element pzb : _filter) {
            boolean _tripleEquals;
            boolean _isInterrupted = Thread.currentThread().isInterrupted();
            if (_isInterrupted) {
                return null;
            }
            RowFactory rg = factory.newRowGroup((Ur_Objekt)pzb);
            boolean _or = false;
            PZB_Art_TypeClass _pZBArt = pzb.getPZBArt();
            ENUMPZBArt _wert = null;
            if (_pZBArt != null) {
                _wert = _pZBArt.getWert();
            }
            boolean bl = _tripleEquals = _wert == ENUMPZBArt.ENUMPZB_ART_2000_HZ;
            if (_tripleEquals) {
                _or = true;
            } else {
                boolean _tripleEquals_1;
                PZB_Art_TypeClass _pZBArt_1 = pzb.getPZBArt();
                ENUMPZBArt _wert_1 = null;
                if (_pZBArt_1 != null) {
                    _wert_1 = _pZBArt_1.getWert();
                }
                _or = _tripleEquals_1 = _wert_1 == ENUMPZBArt.ENUMPZB_ART_1000_2000_HZ;
            }
            boolean isPZB2000 = _or;
            Iterable _fstrDWegs = null;
            if (pzb != null) {
                _fstrDWegs = PZBElementExtensions.getFstrDWegs((PZB_Element)pzb);
            }
            Iterable fstrDwegs = _fstrDWegs;
            if (!isPZB2000 || org.eclipse.xtext.xbase.lib.IterableExtensions.isNullOrEmpty((Iterable)fstrDwegs) || pzb.getPZBElementGM() == null) {
                TableRow instance = rg.newTableRow();
                this.fillRowGroupContent(instance, pzb, null, topGraph);
                continue;
            }
            Iterable _fstrDWegs_1 = null;
            if (pzb != null) {
                _fstrDWegs_1 = PZBElementExtensions.getFstrDWegs((PZB_Element)pzb);
            }
            if (_fstrDWegs_1 == null) continue;
            Consumer<Fstr_DWeg> _function_2 = it -> {
                TableRow instance_1 = rg.newTableRow();
                this.fillRowGroupContent(instance_1, pzb, (Fstr_DWeg)it, topGraph);
            };
            _fstrDWegs_1.forEach(_function_2);
        }
        return factory.getTable();
    }

    private void fillRowGroupContent(TableRow instance, PZB_Element pzb, Fstr_DWeg dweg, TopGraph topGraph) {
        boolean _not;
        boolean _tripleEquals;
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = it_1 -> SskpTransformator.fillBezugsElement(it_1);
            return org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)PZBElementExtensions.getPZBElementBezugspunkt((PZB_Element)it)), (Functions.Function1)_function_1);
        };
        this.fillIterable(instance, this.getColumn(this.cols, "A"), pzb, _function, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR);
        Functions.Function1 _function_1 = it -> {
            PZB_Art_TypeClass _pZBArt = it.getPZBArt();
            String _translate = null;
            if (_pZBArt != null) {
                _translate = this.translate((BasisAttribut_AttributeGroup)_pZBArt);
            }
            return _translate;
        };
        this.fill(instance, this.getColumn(this.cols, "B"), pzb, _function_1);
        boolean _or = false;
        PZB_Art_TypeClass _pZBArt = pzb.getPZBArt();
        ENUMPZBArt _wert = null;
        if (_pZBArt != null) {
            _wert = _pZBArt.getWert();
        }
        boolean bl = _tripleEquals = _wert == ENUMPZBArt.ENUMPZB_ART_2000_HZ;
        if (_tripleEquals) {
            _or = true;
        } else {
            boolean _tripleEquals_1;
            PZB_Art_TypeClass _pZBArt_1 = pzb.getPZBArt();
            ENUMPZBArt _wert_1 = null;
            if (_pZBArt_1 != null) {
                _wert_1 = _pZBArt_1.getWert();
            }
            _or = _tripleEquals_1 = _wert_1 == ENUMPZBArt.ENUMPZB_ART_1000_2000_HZ;
        }
        boolean isPZB2000 = _or;
        if (isPZB2000 && dweg != null && pzb.getPZBElementGM() != null) {
            Functions.Function1 _function_2 = it -> {
                ID_Markanter_Punkt_TypeClass _iDPZBGefahrpunkt = it.getIDPZBGefahrpunkt();
                Markanter_Punkt _value = null;
                if (_iDPZBGefahrpunkt != null) {
                    _value = _iDPZBGefahrpunkt.getValue();
                }
                Markanter_Punkt_Bezeichnung_AttributeGroup _bezeichnung = null;
                if (_value != null) {
                    _bezeichnung = _value.getBezeichnung();
                }
                Bezeichnung_Markanter_Punkt_TypeClass _bezeichnungMarkanterPunkt = null;
                if (_bezeichnung != null) {
                    _bezeichnungMarkanterPunkt = _bezeichnung.getBezeichnungMarkanterPunkt();
                }
                String _wert_2 = null;
                if (_bezeichnungMarkanterPunkt != null) {
                    _wert_2 = _bezeichnungMarkanterPunkt.getWert();
                }
                return _wert_2;
            };
            this.fill(instance, this.getColumn(this.cols, "C"), dweg, _function_2);
            Functions.Function1 _function_3 = it -> {
                ID_Markanter_Punkt_TypeClass _iDPZBGefahrpunkt = it.getIDPZBGefahrpunkt();
                return _iDPZBGefahrpunkt != null;
            };
            Functions.Function1 _function_4 = it -> {
                int dwegV;
                Fstr_DWeg_Spezifisch_AttributeGroup _fstrDWegSpezifisch = it.getFstrDWegSpezifisch();
                DWeg_V_TypeClass _dWegV = null;
                if (_fstrDWegSpezifisch != null) {
                    _dWegV = _fstrDWegSpezifisch.getDWegV();
                }
                BigInteger _wert_2 = null;
                if (_dWegV != null) {
                    _wert_2 = _dWegV.getWert();
                }
                if ((dwegV = BigIntegerExtensions.toInteger(_wert_2)) == 0) {
                    return "";
                }
                if (dwegV > 60) {
                    return "v > 60";
                }
                if (dwegV <= 60 && dwegV > 40) {
                    return "40 < v \u2264 60";
                }
                if (dwegV <= 40) {
                    return "v \u2264 40";
                }
                return "";
            };
            this.fillConditional(instance, this.getColumn(this.cols, "D"), dweg, _function_3, _function_4);
            Functions.Function1 _function_5 = it -> {
                ID_Markanter_Punkt_TypeClass _iDPZBGefahrpunkt = it.getIDPZBGefahrpunkt();
                return _iDPZBGefahrpunkt != null;
            };
            Functions.Function1 _function_6 = it -> {
                boolean _tripleEquals_2;
                Fstr_DWeg_Spezifisch_AttributeGroup _fstrDWegSpezifisch = it.getFstrDWegSpezifisch();
                boolean bl = _tripleEquals_2 = _fstrDWegSpezifisch == null;
                if (_tripleEquals_2) {
                    String _elvis = null;
                    ID_Fstr_Fahrweg_TypeClass _iDFstrFahrweg = it.getIDFstrFahrweg();
                    Fstr_Fahrweg _value = null;
                    if (_iDFstrFahrweg != null) {
                        _value = _iDFstrFahrweg.getValue();
                    }
                    ID_Signal_TypeClass _iDStart = null;
                    if (_value != null) {
                        _iDStart = _value.getIDStart();
                    }
                    Signal _value_1 = null;
                    if (_iDStart != null) {
                        _value_1 = _iDStart.getValue();
                    }
                    PZB_Schutzstrecke_Soll_TypeClass _pZBSchutzstreckeSoll = null;
                    if (_value_1 != null) {
                        _pZBSchutzstreckeSoll = _value_1.getPZBSchutzstreckeSoll();
                    }
                    BigDecimal _wert_2 = null;
                    if (_pZBSchutzstreckeSoll != null) {
                        _wert_2 = _pZBSchutzstreckeSoll.getWert();
                    }
                    String _string = null;
                    if (_wert_2 != null) {
                        _string = _wert_2.toString();
                    }
                    _elvis = _string != null ? _string : "";
                    return _elvis;
                }
                DWeg_V_TypeClass _dWegV = it.getFstrDWegSpezifisch().getDWegV();
                BigInteger _wert_3 = null;
                if (_dWegV != null) {
                    _wert_3 = _dWegV.getWert();
                }
                int dwegV = BigIntegerExtensions.toInteger(_wert_3);
                Fstr_DWeg_Allg_AttributeGroup _fstrDWegAllg = it.getFstrDWegAllg();
                Massgebende_Neigung_TypeClass _massgebendeNeigung = null;
                if (_fstrDWegAllg != null) {
                    _massgebendeNeigung = _fstrDWegAllg.getMassgebendeNeigung();
                }
                BigDecimal _wert_4 = null;
                if (_massgebendeNeigung != null) {
                    _wert_4 = _massgebendeNeigung.getWert();
                }
                double inclination = BigDecimalExtensions.toDouble(_wert_4);
                double _xifexpression = 0.0;
                _xifexpression = inclination > 0.0 ? 0.05 : 0.1;
                double multipleValue = _xifexpression;
                if (dwegV == 0) {
                    return "";
                }
                if (dwegV > 60) {
                    StringConcatenation _builder = new StringConcatenation();
                    long _roundUp = AgateRounding.roundUp((double)(450.0 - inclination * multipleValue * 200.0));
                    _builder.append((Object)_roundUp);
                    return _builder.toString();
                }
                if (dwegV <= 60 && dwegV > 40) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    long _roundUp_1 = AgateRounding.roundUp((double)(350.0 - inclination * multipleValue * 100.0));
                    _builder_1.append((Object)_roundUp_1);
                    return _builder_1.toString();
                }
                if (dwegV <= 40) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    long _xifexpression_1 = 0L;
                    _xifexpression_1 = inclination > 0.0 ? 210L : AgateRounding.roundUp((double)(210.0 - inclination * multipleValue * 50.0));
                    _builder_2.append((Object)_xifexpression_1);
                    return _builder_2.toString();
                }
                return "";
            };
            this.fillConditional(instance, this.getColumn(this.cols, "E"), dweg, _function_5, _function_6);
            Functions.Function1 _function_7 = it -> {
                ID_Markanter_Punkt_TypeClass _iDPZBGefahrpunkt = it.getIDPZBGefahrpunkt();
                return _iDPZBGefahrpunkt != null;
            };
            Functions.Function1 _function_8 = it -> {
                Basis_Objekt markanteStelle;
                ID_Markanter_Punkt_TypeClass _iDPZBGefahrpunkt = null;
                if (dweg != null) {
                    _iDPZBGefahrpunkt = dweg.getIDPZBGefahrpunkt();
                }
                Markanter_Punkt _value = null;
                if (_iDPZBGefahrpunkt != null) {
                    _value = _iDPZBGefahrpunkt.getValue();
                }
                ID_Markante_Stelle_TypeClass _iDMarkanteStelle = null;
                if (_value != null) {
                    _iDMarkanteStelle = _value.getIDMarkanteStelle();
                }
                Basis_Objekt _value_1 = null;
                if (_iDMarkanteStelle != null) {
                    _value_1 = _iDMarkanteStelle.getValue();
                }
                if ((markanteStelle = _value_1) instanceof Punkt_Objekt) {
                    ID_Fstr_Fahrweg_TypeClass _iDFstrFahrweg = dweg.getIDFstrFahrweg();
                    Fstr_Fahrweg _value_2 = null;
                    if (_iDFstrFahrweg != null) {
                        _value_2 = _iDFstrFahrweg.getValue();
                    }
                    ID_Signal_TypeClass _iDStart = null;
                    if (_value_2 != null) {
                        _iDStart = _value_2.getIDStart();
                    }
                    Signal _value_3 = null;
                    if (_iDStart != null) {
                        _value_3 = _iDStart.getValue();
                    }
                    return Long.valueOf(AgateRounding.roundDown((double)((Double)org.eclipse.xtext.xbase.lib.IterableExtensions.min(this.getPointsDistance((Punkt_Objekt)markanteStelle, (Punkt_Objekt)_value_3))))).toString();
                }
                return "";
            };
            this.fillConditional(instance, this.getColumn(this.cols, "F"), dweg, _function_7, _function_8);
        }
        Functions.Function1 _function_9 = it -> {
            Functions.Function1 _function_10 = pzbZuordnungBp -> {
                String _switchResult = null;
                Wirksamkeit_TypeClass _wirksamkeit = pzbZuordnungBp.getWirksamkeit();
                ENUMWirksamkeit _wert_2 = null;
                if (_wirksamkeit != null) {
                    _wert_2 = _wirksamkeit.getWert();
                }
                if (_wert_2 != null) {
                    switch (_wert_2) {
                        case ENUM_WIRKSAMKEIT_SCHALTBAR_VON_SIGNAL: 
                        case ENUM_WIRKSAMKEIT_SONSTIGE: {
                            Wirksamkeit_TypeClass _wirksamkeit_1 = pzbZuordnungBp.getWirksamkeit();
                            String _translate = null;
                            if (_wirksamkeit_1 != null) {
                                _translate = this.translate((BasisAttribut_AttributeGroup)_wirksamkeit_1);
                            }
                            _switchResult = _translate;
                            break;
                        }
                        case ENUM_WIRKSAMKEIT_STAENDIG_WIRKSAM: {
                            String _xifexpression = null;
                            _xifexpression = pzb.getPZBElementGUE() != null && pzb.getPZBElementGUE().getIDPZBElementMitnutzung() == null ? "st\u00e4. akt." : "st\u00e4. wirk.";
                            _switchResult = _xifexpression;
                            break;
                        }
                    }
                }
                return _switchResult;
            };
            return org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)PZBElementExtensions.getPZBElementZuordnungBP((PZB_Element)it), (Functions.Function1)_function_10);
        };
        this.fillIterable(instance, this.getColumn(this.cols, "G"), pzb, _function_9, null);
        Functions.Function1 _function_10 = it -> {
            Functions.Function1 _function_11 = it_1 -> {
                ENUMSignalFunktion _wert_2 = it_1.getSignalReal().getSignalFunktion().getWert();
                return _wert_2 == ENUMSignalFunktion.ENUM_SIGNAL_FUNKTION_BUE_UEBERWACHUNGSSIGNAL;
            };
            Functions.Function1 _function_12 = signal -> {
                Signal _value = it.getIDSignal().getValue();
                return signal == _value;
            };
            return org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)Iterables.filter((Iterable)PZBElementExtensions.getPZBElementBezugspunkt((PZB_Element)pzb), Signal.class), (Functions.Function1)_function_11), (Functions.Function1)_function_12);
        };
        Iterable bueSpezifischeSignals = org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)pzb).getBUESpezifischesSignal(), (Functions.Function1)_function_10);
        ColumnDescriptor _column = this.getColumn(this.cols, "H");
        Functions.Function1 _function_11 = it -> !org.eclipse.xtext.xbase.lib.IterableExtensions.isEmpty((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)PZBElementExtensions.getPZBElementZuordnungFstr((PZB_Element)it), it_1 -> {
            ID_Fstr_Zug_Rangier_TypeClass _iDFstrZugRangier = it_1.getIDFstrZugRangier();
            Fstr_Zug_Rangier _value = null;
            if (_iDFstrZugRangier != null) {
                _value = _iDFstrZugRangier.getValue();
            }
            return _value;
        })) || it.getPZBElementGUE() != null && org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)PZBElementExtensions.getPZBElementZuordnungFstr((PZB_Element)it), it_1 -> {
            Wirksamkeit_Fstr_TypeClass _wirksamkeitFstr = it_1.getWirksamkeitFstr();
            ENUMWirksamkeitFstr _wert_2 = null;
            if (_wirksamkeitFstr != null) {
                _wert_2 = _wirksamkeitFstr.getWert();
            }
            return _wert_2 == ENUMWirksamkeitFstr.ENUM_WIRKSAMKEIT_FSTR_STAENDIG_WIRKSAM_WENN_FAHRSTRASSE_EINGESTELLT;
        });
        Functions.Function1 _function_12 = it -> {
            Functions.Function1 _function_13 = pzbZuordnung -> {
                Wirksamkeit_Fstr_TypeClass _wirksamkeitFstr = pzbZuordnung.getWirksamkeitFstr();
                String _translate = null;
                if (_wirksamkeitFstr != null) {
                    _translate = this.translate((BasisAttribut_AttributeGroup)_wirksamkeitFstr);
                }
                String wirksamKeit = _translate;
                ID_Fstr_Zug_Rangier_TypeClass _iDFstrZugRangier = pzbZuordnung.getIDFstrZugRangier();
                Fstr_Zug_Rangier _value = null;
                if (_iDFstrZugRangier != null) {
                    _value = _iDFstrZugRangier.getValue();
                }
                String _fstrZugRangierBezeichnung = null;
                if (_value != null) {
                    _fstrZugRangierBezeichnung = FstrZugRangierExtensions.getFstrZugRangierBezeichnung((Fstr_Zug_Rangier)_value);
                }
                String fstrZugRangier = _fstrZugRangierBezeichnung;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(wirksamKeit);
                _builder.append(" ");
                _builder.append(fstrZugRangier);
                return _builder.toString();
            };
            return org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)PZBElementExtensions.getPZBElementZuordnungFstr((PZB_Element)it), (Functions.Function1)_function_13);
        };
        Case _case = new Case(_function_11, _function_12, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR, null);
        Functions.Function1 _function_13 = it -> {
            Functions.Function1 _function_14 = it_1 -> {
                Wirksamkeit_Fstr_TypeClass _wirksamkeitFstr = it_1.getWirksamkeitFstr();
                ENUMWirksamkeitFstr _wert_2 = null;
                if (_wirksamkeitFstr != null) {
                    _wert_2 = _wirksamkeitFstr.getWert();
                }
                return Objects.equals(_wert_2, ENUMWirksamkeitFstr.ENUM_WIRKSAMKEIT_FSTR_SONSTIGE);
            };
            return org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)PZBElementExtensions.getPZBElementZuordnungFstr((PZB_Element)it), (Functions.Function1)_function_14);
        };
        Functions.Function1 _function_14 = it -> {
            ID_PZB_Element_Zuordnung_TypeClass _iDPZBElementZuordnung = it.getIDPZBElementZuordnung();
            PZB_Element_Zuordnung _value = null;
            if (_iDPZBElementZuordnung != null) {
                _value = _iDPZBElementZuordnung.getValue();
            }
            EList _pZBElementZuordnungFstr = null;
            if (_value != null) {
                _pZBElementZuordnungFstr = _value.getPZBElementZuordnungFstr();
            }
            Functions.Function1 _function_15 = it_1 -> {
                Wirksamkeit_Fstr_TypeClass _wirksamkeitFstr = it_1.getWirksamkeitFstr();
                EList _iDBearbeitungsvermerk = null;
                if (_wirksamkeitFstr != null) {
                    _iDBearbeitungsvermerk = _wirksamkeitFstr.getIDBearbeitungsvermerk();
                }
                return _iDBearbeitungsvermerk;
            };
            Functions.Function1 _function_16 = it_1 -> {
                Bearbeitungsvermerk _value_1 = it_1.getValue();
                Bearbeitungsvermerk_Allg_AttributeGroup _bearbeitungsvermerkAllg = null;
                if (_value_1 != null) {
                    _bearbeitungsvermerkAllg = _value_1.getBearbeitungsvermerkAllg();
                }
                Kurztext_TypeClass _kurztext = null;
                if (_bearbeitungsvermerkAllg != null) {
                    _kurztext = _bearbeitungsvermerkAllg.getKurztext();
                }
                String _wert_2 = null;
                if (_kurztext != null) {
                    _wert_2 = _kurztext.getWert();
                }
                return _wert_2;
            };
            return org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.flatMap((Iterable)_pZBElementZuordnungFstr, (Functions.Function1)_function_15), (Functions.Function1)_function_16));
        };
        Case _case_1 = new Case(_function_13, _function_14, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR);
        Functions.Function1 _function_15 = it -> {
            boolean _isEmpty = org.eclipse.xtext.xbase.lib.IterableExtensions.isEmpty((Iterable)bueSpezifischeSignals);
            return !_isEmpty;
        };
        Functions.Function1 _function_16 = it -> {
            Functions.Function1 _function_17 = it_1 -> {
                ID_BUE_Anlage_TypeClass _iDBUEAnlage = it_1.getIDBUEAnlage();
                BUE_Anlage _value = null;
                if (_iDBUEAnlage != null) {
                    _value = _iDBUEAnlage.getValue();
                }
                Bezeichnung_Element_AttributeGroup _bezeichnung = null;
                if (_value != null) {
                    _bezeichnung = _value.getBezeichnung();
                }
                Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
                if (_bezeichnung != null) {
                    _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
                }
                String _wert_2 = null;
                if (_bezeichnungTabelle != null) {
                    _wert_2 = _bezeichnungTabelle.getWert();
                }
                return _wert_2;
            };
            return org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)bueSpezifischeSignals, (Functions.Function1)_function_17);
        };
        Case _case_2 = new Case(_function_15, _function_16, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR);
        this.fillSwitch(instance, _column, pzb, new Case[]{_case, _case_1, _case_2});
        Functions.Function1 _function_17 = it -> {
            Functions.Function1 _function_18 = it_1 -> this.getDistanceSignalTrackSwitch(topGraph, pzb, (Basis_Objekt)it_1);
            return org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)PZBElementExtensions.getPZBElementBezugspunkt((PZB_Element)it)), (Functions.Function1)_function_18);
        };
        this.fillIterable(instance, this.getColumn(this.cols, "I"), pzb, _function_17, null);
        Functions.Function1 _function_18 = it -> {
            boolean _tripleEquals_2;
            Iterable _xblockexpression = null;
            PZB_Art_TypeClass _pZBArt_2 = it.getPZBArt();
            ENUMPZBArt _wert_2 = null;
            if (_pZBArt_2 != null) {
                _wert_2 = _pZBArt_2.getWert();
            }
            boolean bl = _tripleEquals_2 = _wert_2 == ENUMPZBArt.ENUMPZB_ART_2000_HZ;
            if (_tripleEquals_2) {
                return Collections.unmodifiableList(CollectionLiterals.newArrayList());
            }
            Functions.Function1 _function_19 = pzbEle -> {
                boolean _and = false;
                boolean _and_1 = false;
                if (pzbEle == it) {
                    _and_1 = false;
                } else {
                    boolean _tripleEquals_3;
                    boolean _or_1 = false;
                    PZB_Art_TypeClass _pZBArt_3 = pzbEle.getPZBArt();
                    ENUMPZBArt _wert_3 = null;
                    if (_pZBArt_3 != null) {
                        _wert_3 = _pZBArt_3.getWert();
                    }
                    boolean bl = _tripleEquals_3 = _wert_3 == ENUMPZBArt.ENUMPZB_ART_2000_HZ;
                    if (_tripleEquals_3) {
                        _or_1 = true;
                    } else {
                        boolean _tripleEquals_4;
                        PZB_Art_TypeClass _pZBArt_4 = pzbEle.getPZBArt();
                        ENUMPZBArt _wert_4 = null;
                        if (_pZBArt_4 != null) {
                            _wert_4 = _pZBArt_4.getWert();
                        }
                        _or_1 = _tripleEquals_4 = _wert_4 == ENUMPZBArt.ENUMPZB_ART_1000_2000_HZ;
                    }
                    _and_1 = _or_1;
                }
                if (!_and_1) {
                    _and = false;
                } else {
                    boolean _tripleNotEquals;
                    PZB_Element_GM_AttributeGroup _pZBElementGM = null;
                    if (pzbEle != null) {
                        _pZBElementGM = pzbEle.getPZBElementGM();
                    }
                    _and = _tripleNotEquals = _pZBElementGM != null;
                }
                return _and;
            };
            List pzbGM2000 = org.eclipse.xtext.xbase.lib.IterableExtensions.toList((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)it).getPZBElement(), (Functions.Function1)_function_19));
            Iterable bezugspunktSignals = Iterables.filter((Iterable)PZBElementExtensions.getPZBElementBezugspunkt((PZB_Element)it), Signal.class);
            Functions.Function1 _function_20 = pzbEle -> {
                boolean _tripleEquals_3;
                PZB_Art_TypeClass _pZBArt_3 = it.getPZBArt();
                ENUMPZBArt _wert_3 = null;
                if (_pZBArt_3 != null) {
                    _wert_3 = _pZBArt_3.getWert();
                }
                boolean bl = _tripleEquals_3 = _wert_3 == ENUMPZBArt.ENUMPZB_ART_500_HZ;
                if (_tripleEquals_3) {
                    Functions.Function1 _function_21 = signal -> org.eclipse.xtext.xbase.lib.IterableExtensions.contains((Iterable)bezugspunktSignals, (Object)signal);
                    return org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)Iterables.filter((Iterable)PZBElementExtensions.getPZBElementBezugspunkt((PZB_Element)pzbEle), Signal.class), (Functions.Function1)_function_21);
                }
                Functions.Function1 _function_22 = it_1 -> {
                    ID_Signal_TypeClass _iDSignal = it_1.getIDSignal();
                    Signal _value = null;
                    if (_iDSignal != null) {
                        _value = _iDSignal.getValue();
                    }
                    return _value;
                };
                Functions.Function1 _function_23 = signal -> org.eclipse.xtext.xbase.lib.IterableExtensions.contains((Iterable)bezugspunktSignals, (Object)signal);
                return org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)PZBElementExtensions.getPZBZuordnungSignal((PZB_Element)pzbEle), (Functions.Function1)_function_22)), (Functions.Function1)_function_23);
            };
            Functions.Function1 _function_21 = pzbEle -> {
                Double _min = (Double)org.eclipse.xtext.xbase.lib.IterableExtensions.min(this.getPointsDistance((Punkt_Objekt)it, (Punkt_Objekt)pzbEle));
                return Pair.of((Object)pzbEle, (Object)_min);
            };
            Functions.Function1 _function_22 = it_1 -> {
                double _doubleValue = (Double)it_1.getValue();
                return _doubleValue != 0.0;
            };
            Functions.Function1 _function_23 = pair -> {
                boolean _tripleEquals_3;
                String distance = Long.valueOf(AgateRounding.roundDown((double)((Double)pair.getValue()))).toString();
                PZB_Art_TypeClass _pZBArt_3 = it.getPZBArt();
                ENUMPZBArt _wert_3 = null;
                if (_pZBArt_3 != null) {
                    _wert_3 = _pZBArt_3.getWert();
                }
                boolean bl = _tripleEquals_3 = _wert_3 == ENUMPZBArt.ENUMPZB_ART_500_HZ;
                if (_tripleEquals_3) {
                    return distance;
                }
                Signal signal = (Signal)IterableExtensions.getFirstOrNull((Iterable)Iterables.filter((Iterable)PZBElementExtensions.getPZBElementBezugspunkt((PZB_Element)((PZB_Element)pair.getKey())), Signal.class));
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(distance);
                _builder.append(" ");
                if (signal != null) {
                    _builder.append("(");
                    Bezeichnung_Element_AttributeGroup _bezeichnung = signal.getBezeichnung();
                    Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
                    if (_bezeichnung != null) {
                        _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
                    }
                    String _wert_4 = null;
                    if (_bezeichnungTabelle != null) {
                        _wert_4 = _bezeichnungTabelle.getWert();
                    }
                    _builder.append(_wert_4);
                    _builder.append(")");
                }
                return _builder.toString();
            };
            _xblockexpression = org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)pzbGM2000, (Functions.Function1)_function_20)), (Functions.Function1)_function_21), (Functions.Function1)_function_22), (Functions.Function1)_function_23);
            return _xblockexpression;
        };
        this.fillIterable(instance, this.getColumn(this.cols, "J"), pzb, _function_18, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR);
        if (PZBElementExtensions.getPZBElementZuordnungBP((PZB_Element)pzb) != null && org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)PZBElementExtensions.getPZBElementZuordnungBP((PZB_Element)pzb), it -> {
            PZB_Element_Zuordnung_INA_AttributeGroup _pZBElementZuordnungINA = it.getPZBElementZuordnungINA();
            return _pZBElementZuordnungINA != null;
        }) && isPZB2000) {
            Functions.Function1 _function_19 = it -> it.getINAGefahrstelle();
            Iterable inaGefahrstelles = Iterables.concat((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)PZBElementExtensions.getPZBElementZuordnungBP((PZB_Element)pzb), (Functions.Function1)_function_19));
            boolean isGefahrstelle = org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)inaGefahrstelles, it -> {
                int _intValue;
                Prioritaet_Gefahrstelle_TypeClass _prioritaetGefahrstelle = it.getPrioritaetGefahrstelle();
                BigInteger _wert_2 = null;
                if (_prioritaetGefahrstelle != null) {
                    _wert_2 = _prioritaetGefahrstelle.getWert();
                }
                return (_intValue = _wert_2.intValue()) == 1;
            }) && !org.eclipse.xtext.xbase.lib.IterableExtensions.isEmpty((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)inaGefahrstelles, it -> it.getIDMarkanterPunkt()));
            Functions.Function1 _function_20 = it -> isGefahrstelle;
            Functions.Function1 _function_21 = it -> {
                Functions.Function1 _function_22 = it_1 -> {
                    ID_Markanter_Punkt_TypeClass _iDMarkanterPunkt = it_1.getIDMarkanterPunkt();
                    Markanter_Punkt _value = null;
                    if (_iDMarkanterPunkt != null) {
                        _value = _iDMarkanterPunkt.getValue();
                    }
                    Markanter_Punkt_Bezeichnung_AttributeGroup _bezeichnung = null;
                    if (_value != null) {
                        _bezeichnung = _value.getBezeichnung();
                    }
                    Bezeichnung_Markanter_Punkt_TypeClass _bezeichnungMarkanterPunkt = null;
                    if (_bezeichnung != null) {
                        _bezeichnungMarkanterPunkt = _bezeichnung.getBezeichnungMarkanterPunkt();
                    }
                    String _wert_2 = null;
                    if (_bezeichnungMarkanterPunkt != null) {
                        _wert_2 = _bezeichnungMarkanterPunkt.getWert();
                    }
                    return _wert_2;
                };
                return org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)inaGefahrstelles, (Functions.Function1)_function_22);
            };
            this.fillIterableWithConditional(instance, this.getColumn(this.cols, "K"), pzb, _function_20, _function_21, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR);
            Functions.Function1 _function_22 = it -> isGefahrstelle;
            Functions.Function1 _function_23 = it -> {
                Functions.Function1 _function_24 = it_1 -> {
                    ID_Markanter_Punkt_TypeClass _iDMarkanterPunkt = it_1.getIDMarkanterPunkt();
                    Markanter_Punkt _value = null;
                    if (_iDMarkanterPunkt != null) {
                        _value = _iDMarkanterPunkt.getValue();
                    }
                    ID_Markante_Stelle_TypeClass _iDMarkanteStelle = null;
                    if (_value != null) {
                        _iDMarkanteStelle = _value.getIDMarkanteStelle();
                    }
                    Basis_Objekt _value_1 = null;
                    if (_iDMarkanteStelle != null) {
                        _value_1 = _iDMarkanteStelle.getValue();
                    }
                    return _value_1;
                };
                Iterable markanteStelle = Iterables.filter((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)inaGefahrstelles, (Functions.Function1)_function_24), Punkt_Objekt.class);
                return this.getDistanceOfPoints(markanteStelle, (Punkt_Objekt)it);
            };
            this.fillConditional(instance, this.getColumn(this.cols, "L"), pzb, _function_22, _function_23);
            Iterable _pZBElementZuordnungBP = null;
            if (pzb != null) {
                _pZBElementZuordnungBP = PZBElementExtensions.getPZBElementZuordnungBP((PZB_Element)pzb);
            }
            Iterable _map = null;
            if (_pZBElementZuordnungBP != null) {
                Functions.Function1 _function_24 = it -> it.getPZBElementZuordnungINA();
                _map = org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)_pZBElementZuordnungBP, (Functions.Function1)_function_24);
            }
            Iterable _map_1 = null;
            if (_map != null) {
                Functions.Function1 _function_25 = it -> {
                    ID_Bahnsteig_Kante_TypeClass _iDBahnsteigKante = it.getIDBahnsteigKante();
                    Bahnsteig_Kante _value = null;
                    if (_iDBahnsteigKante != null) {
                        _value = _iDBahnsteigKante.getValue();
                    }
                    return _value;
                };
                _map_1 = org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)_map, (Functions.Function1)_function_25);
            }
            List bahnSteigKantes = org.eclipse.xtext.xbase.lib.IterableExtensions.toList(_map_1);
            SskpBahnsteigUtils.BahnsteigDistance bahnsteigDistance = SskpBahnsteigUtils.getBahnsteigDistances(bahnSteigKantes, pzb);
            Functions.Function1 _function_26 = it -> bahnsteigDistance.getDistanceStart().isPresent();
            Functions.Function1 _function_27 = it -> DoubleExtensions.toTableInteger((Double)bahnsteigDistance.getDistanceStart().getAsDouble());
            this.fillConditional(instance, this.getColumn(this.cols, "M"), pzb, _function_26, _function_27);
            Functions.Function1 _function_28 = it -> bahnsteigDistance.getDistanceEnd().isPresent();
            Functions.Function1 _function_29 = it -> DoubleExtensions.toTableInteger((Double)bahnsteigDistance.getDistanceEnd().getAsDouble());
            this.fillConditional(instance, this.getColumn(this.cols, "N"), pzb, _function_28, _function_29);
            Functions.Function1 _function_30 = it -> {
                Iterable _pZBZuordnungSignal = PZBElementExtensions.getPZBZuordnungSignal((PZB_Element)it);
                Iterable _map_2 = null;
                if (_pZBZuordnungSignal != null) {
                    Functions.Function1 _function_31 = it_1 -> {
                        ID_Signal_TypeClass _iDSignal = it_1.getIDSignal();
                        Signal _value = null;
                        if (_iDSignal != null) {
                            _value = _iDSignal.getValue();
                        }
                        List _signalRahmen = null;
                        if (_value != null) {
                            _signalRahmen = SignalExtensions.signalRahmen((Signal)_value);
                        }
                        return _signalRahmen;
                    };
                    _map_2 = org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)_pZBZuordnungSignal, (Functions.Function1)_function_31);
                }
                Functions.Function1 _function_32 = it_1 -> SignalRahmenExtensions.getSignalbegriffe((Signal_Rahmen)it_1);
                Functions.Function1 _function_33 = it_1 -> SignalbegriffExtensions.hasSignalbegriffID((Signal_Signalbegriff)it_1, Ne5.class);
                return org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)Iterables.concat((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)Iterables.concat((Iterable)_map_2), (Functions.Function1)_function_32)), (Functions.Function1)_function_33);
            };
            Functions.Function1 _function_31 = it -> {
                Iterable _pZBZuordnungSignal = PZBElementExtensions.getPZBZuordnungSignal((PZB_Element)it);
                Iterable _map_2 = null;
                if (_pZBZuordnungSignal != null) {
                    Functions.Function1 _function_32 = it_1 -> {
                        ID_Signal_TypeClass _iDSignal = it_1.getIDSignal();
                        Signal _value = null;
                        if (_iDSignal != null) {
                            _value = _iDSignal.getValue();
                        }
                        return _value;
                    };
                    _map_2 = org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)_pZBZuordnungSignal, (Functions.Function1)_function_32);
                }
                Functions.Function1 _function_33 = signal -> (Double)org.eclipse.xtext.xbase.lib.IterableExtensions.min(this.getPointsDistance((Punkt_Objekt)pzb, (Punkt_Objekt)signal));
                Functions.Function1 _function_34 = it_1 -> {
                    double _doubleValue = it_1;
                    return _doubleValue != 0.0;
                };
                Functions.Function1 _function_35 = it_1 -> Long.valueOf(AgateRounding.roundDown((double)it_1)).toString();
                return org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)_map_2, (Functions.Function1)_function_33), (Functions.Function1)_function_34), (Functions.Function1)_function_35);
            };
            this.fillIterableWithConditional(instance, this.getColumn(this.cols, "O"), pzb, _function_30, _function_31, (Comparator)ToolboxConstants.NUMERIC_COMPARATOR, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR);
            Iterable _pZBZuordnungSignal = PZBElementExtensions.getPZBZuordnungSignal((PZB_Element)pzb);
            Iterable _map_2 = null;
            if (_pZBZuordnungSignal != null) {
                Functions.Function1 _function_32 = it -> {
                    ID_Signal_TypeClass _iDSignal = it.getIDSignal();
                    Signal _value = null;
                    if (_iDSignal != null) {
                        _value = _iDSignal.getValue();
                    }
                    return _value;
                };
                _map_2 = org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)_pZBZuordnungSignal, (Functions.Function1)_function_32);
            }
            Functions.Function1 _function_33 = it -> {
                Signal_Real_AttributeGroup _signalReal = it.getSignalReal();
                Signal_Real_Aktiv_Schirm_AttributeGroup _signalRealAktivSchirm = null;
                if (_signalReal != null) {
                    _signalRealAktivSchirm = _signalReal.getSignalRealAktivSchirm();
                }
                Signal_Art_TypeClass _signalArt = null;
                if (_signalRealAktivSchirm != null) {
                    _signalArt = _signalRealAktivSchirm.getSignalArt();
                }
                ENUMSignalArt _wert_2 = null;
                if (_signalArt != null) {
                    _wert_2 = _signalArt.getWert();
                }
                return _wert_2 == ENUMSignalArt.ENUM_SIGNAL_ART_VORSIGNALWIEDERHOLER;
            };
            Iterable vorSignalWiederholer = org.eclipse.xtext.xbase.lib.IterableExtensions.filter(_map_2, (Functions.Function1)_function_33);
            Functions.Function1 _function_34 = it -> {
                boolean _isNullOrEmpty = org.eclipse.xtext.xbase.lib.IterableExtensions.isNullOrEmpty((Iterable)vorSignalWiederholer);
                return !_isNullOrEmpty;
            };
            Functions.Function1 _function_35 = it -> {
                Functions.Function1 _function_36 = signal -> {
                    Double _min = (Double)org.eclipse.xtext.xbase.lib.IterableExtensions.min(this.getPointsDistance((Punkt_Objekt)pzb, (Punkt_Objekt)signal));
                    return Pair.of((Object)signal, (Object)_min);
                };
                Functions.Function1 _function_37 = it_1 -> {
                    double _doubleValue = (Double)it_1.getValue();
                    return _doubleValue != 0.0;
                };
                Functions.Function1 _function_38 = it_1 -> {
                    StringConcatenation _builder = new StringConcatenation();
                    String _string = Long.valueOf(AgateRounding.roundDown((double)((Double)it_1.getValue()))).toString();
                    _builder.append(_string);
                    _builder.append(" ");
                    _builder.append("(");
                    Bezeichnung_Element_AttributeGroup _bezeichnung = ((Signal)it_1.getKey()).getBezeichnung();
                    Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
                    if (_bezeichnung != null) {
                        _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
                    }
                    String _wert_2 = null;
                    if (_bezeichnungTabelle != null) {
                        _wert_2 = _bezeichnungTabelle.getWert();
                    }
                    _builder.append(_wert_2);
                    _builder.append(")");
                    return _builder.toString();
                };
                return org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)vorSignalWiederholer, (Functions.Function1)_function_36), (Functions.Function1)_function_37), (Functions.Function1)_function_38);
            };
            this.fillIterableWithConditional(instance, this.getColumn(this.cols, "P"), pzb, _function_34, _function_35, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR);
            Functions.Function1 _function_36 = it -> "";
            this.fill(instance, this.getColumn(this.cols, "Q"), pzb, _function_36);
        } else {
            int i = 10;
            while (i < 17) {
                this.fillBlank(instance, i);
                ++i;
            }
        }
        Functions.Function1 _function_37 = it -> it.getPZBElementGUE();
        Functions.Function1 _function_38 = it -> {
            ID_PZB_Element_Mitnutzung_TypeClass _iDPZBElementMitnutzung = it.getIDPZBElementMitnutzung();
            PZB_Element _value = null;
            if (_iDPZBElementMitnutzung != null) {
                _value = _iDPZBElementMitnutzung.getValue();
            }
            return _value == pzb;
        };
        Iterable _filter = org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)BasisAttributExtensions.getContainer((EObject)pzb).getPZBElement(), (Functions.Function1)_function_37)), (Functions.Function1)_function_38);
        PZB_Element_GUE_AttributeGroup _pZBElementGUE = pzb.getPZBElementGUE();
        Iterable pzbGUEs = org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)Iterables.concat((Iterable)_filter, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new PZB_Element_GUE_AttributeGroup[]{_pZBElementGUE}))));
        boolean _isEmpty = org.eclipse.xtext.xbase.lib.IterableExtensions.isEmpty((Iterable)pzbGUEs);
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            Functions.Function1 _function_39 = it -> pzbGUEs;
            Functions.Function1 _function_40 = it -> {
                Pruefgeschwindigkeit_TypeClass _pruefgeschwindigkeit = it.getPruefgeschwindigkeit();
                BigInteger _wert_2 = null;
                if (_pruefgeschwindigkeit != null) {
                    _wert_2 = _pruefgeschwindigkeit.getWert();
                }
                return Integer.valueOf(_wert_2.intValue()).toString();
            };
            this.fillIterable(instance, this.getColumn(this.cols, "R"), pzb, _function_39, null, _function_40);
            Functions.Function1 _function_41 = it -> pzbGUEs;
            Functions.Function1 _function_42 = it -> {
                Pruefzeit_TypeClass _pruefzeit = it.getPruefzeit();
                BigDecimal _wert_2 = null;
                if (_pruefzeit != null) {
                    _wert_2 = _pruefzeit.getWert();
                }
                return BigDecimalExtensions.toTableDecimal((BigDecimal)_wert_2, (int)2);
            };
            this.fillIterable(instance, this.getColumn(this.cols, "S"), pzb, _function_41, null, _function_42);
            Functions.Function1 _function_43 = it -> pzbGUEs;
            Functions.Function1 _function_44 = it -> {
                Messfehler_TypeClass _messfehler = it.getMessfehler();
                String _translate = null;
                if (_messfehler != null) {
                    _translate = this.translate((BasisAttribut_AttributeGroup)_messfehler);
                }
                return _translate;
            };
            this.fillIterable(instance, this.getColumn(this.cols, "T"), pzb, _function_43, null, _function_44);
            Functions.Function1 _function_45 = it -> pzbGUEs;
            Functions.Function1 _function_46 = it -> {
                GUE_Messstrecke_TypeClass _gUEMessstrecke = it.getGUEMessstrecke();
                BigDecimal _wert_2 = null;
                if (_gUEMessstrecke != null) {
                    _wert_2 = _gUEMessstrecke.getWert();
                }
                return Integer.valueOf(_wert_2.intValue()).toString();
            };
            this.fillIterable(instance, this.getColumn(this.cols, "U"), pzb, _function_45, null, _function_46);
            Functions.Function1 _function_47 = it -> pzbGUEs;
            Functions.Function1 _function_48 = it -> {
                GUE_Anordnung_TypeClass _gUEAnordnung = it.getGUEAnordnung();
                String _translate = null;
                if (_gUEAnordnung != null) {
                    _translate = this.translate((BasisAttribut_AttributeGroup)_gUEAnordnung);
                }
                return _translate;
            };
            this.fillIterable(instance, this.getColumn(this.cols, "V"), pzb, _function_47, null, _function_48);
            Functions.Function1 _function_49 = it -> pzbGUEs;
            Functions.Function1 _function_50 = it -> {
                GUE_Bauart_TypeClass _gUEBauart = it.getGUEBauart();
                String _translate = null;
                if (_gUEBauart != null) {
                    _translate = this.translate((BasisAttribut_AttributeGroup)_gUEBauart);
                }
                return _translate;
            };
            this.fillIterable(instance, this.getColumn(this.cols, "W"), pzb, _function_49, null, _function_50);
            Functions.Function1 _function_51 = it -> {
                String _elvis = null;
                ID_Unterbringung_TypeClass _iDUnterbringung = it.getIDUnterbringung();
                Unterbringung _value = null;
                if (_iDUnterbringung != null) {
                    _value = _iDUnterbringung.getValue();
                }
                Unterbringung_Allg_AttributeGroup _unterbringungAllg = null;
                if (_value != null) {
                    _unterbringungAllg = _value.getUnterbringungAllg();
                }
                Unterbringung_Befestigung_TypeClass _unterbringungBefestigung = null;
                if (_unterbringungAllg != null) {
                    _unterbringungBefestigung = _unterbringungAllg.getUnterbringungBefestigung();
                }
                String _translate = null;
                if (_unterbringungBefestigung != null) {
                    _translate = this.translate((BasisAttribut_AttributeGroup)_unterbringungBefestigung);
                }
                _elvis = _translate != null ? _translate : "";
                return _elvis;
            };
            this.fill(instance, this.getColumn(this.cols, "X"), pzb, _function_51);
            Functions.Function1 _function_52 = it -> pzbGUEs;
            Functions.Function1 _function_53 = it -> {
                GUE_Energieversorgung_TypeClass _gUEEnergieversorgung = it.getGUEEnergieversorgung();
                String _translate = null;
                if (_gUEEnergieversorgung != null) {
                    _translate = this.translate((BasisAttribut_AttributeGroup)_gUEEnergieversorgung);
                }
                return _translate;
            };
            this.fillIterable(instance, this.getColumn(this.cols, "Y"), pzb, _function_52, null, _function_53);
        } else {
            int i = 17;
            while (i < 25) {
                this.fillBlank(instance, i);
                ++i;
            }
        }
        Functions.Function1 _function_54 = it -> null;
        this.fill(instance, this.getColumn(this.cols, "Z"), pzb, _function_54);
        this.fillFootnotes(instance, (Basis_Objekt)pzb);
    }

    protected static String _fillBezugsElement(Basis_Objekt object) {
        String _simpleName = object.getClass().getSimpleName();
        throw new IllegalArgumentException(_simpleName);
    }

    protected static String _fillBezugsElement(W_Kr_Gsp_Element object) {
        Bezeichnung_Element_AttributeGroup _bezeichnung = null;
        if (object != null) {
            _bezeichnung = object.getBezeichnung();
        }
        Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
        if (_bezeichnung != null) {
            _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
        }
        String _wert = null;
        if (_bezeichnungTabelle != null) {
            _wert = _bezeichnungTabelle.getWert();
        }
        return _wert;
    }

    protected static String _fillBezugsElement(Signal object) {
        boolean _tripleEquals;
        String _xifexpression = null;
        ENUMSignalFunktion _wert = object.getSignalReal().getSignalFunktion().getWert();
        boolean bl = _tripleEquals = _wert == ENUMSignalFunktion.ENUM_SIGNAL_FUNKTION_BUE_UEBERWACHUNGSSIGNAL;
        if (_tripleEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("B\u00dc-K ");
            Bezeichnung_Element_AttributeGroup _bezeichnung = null;
            if (object != null) {
                _bezeichnung = object.getBezeichnung();
            }
            Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
            if (_bezeichnung != null) {
                _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
            }
            String _wert_1 = null;
            if (_bezeichnungTabelle != null) {
                _wert_1 = _bezeichnungTabelle.getWert();
            }
            _builder.append(_wert_1);
            _xifexpression = _builder.toString();
        } else {
            Bezeichnung_Element_AttributeGroup _bezeichnung_1 = null;
            if (object != null) {
                _bezeichnung_1 = object.getBezeichnung();
            }
            Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle_1 = null;
            if (_bezeichnung_1 != null) {
                _bezeichnungTabelle_1 = _bezeichnung_1.getBezeichnungTabelle();
            }
            String _wert_2 = null;
            if (_bezeichnungTabelle_1 != null) {
                _wert_2 = _bezeichnungTabelle_1.getWert();
            }
            _xifexpression = _wert_2;
        }
        return _xifexpression;
    }

    private String _getDistanceSignalTrackSwitch(TopGraph topGraph, PZB_Element pzb, Basis_Objekt object) {
        String _simpleName = object.getClass().getSimpleName();
        throw new IllegalArgumentException(_simpleName);
    }

    private String _getDistanceSignalTrackSwitch(TopGraph topGraph, PZB_Element pzb, Signal signal) {
        boolean _tripleNotEquals;
        Signal_Real_AttributeGroup _signalReal = null;
        if (signal != null) {
            _signalReal = signal.getSignalReal();
        }
        Signal_Funktion_TypeClass _signalFunktion = null;
        if (_signalReal != null) {
            _signalFunktion = _signalReal.getSignalFunktion();
        }
        ENUMSignalFunktion _wert = null;
        if (_signalFunktion != null) {
            _wert = _signalFunktion.getWert();
        }
        boolean bl = _tripleNotEquals = _wert != ENUMSignalFunktion.ENUM_SIGNAL_FUNKTION_BUE_UEBERWACHUNGSSIGNAL;
        if (_tripleNotEquals) {
            long distance = AgateRounding.roundDown((double)((Double)org.eclipse.xtext.xbase.lib.IterableExtensions.min(this.getPointsDistance((Punkt_Objekt)pzb, (Punkt_Objekt)signal))));
            String _xifexpression = null;
            boolean _isInWirkrichtungOfSignal = SignalExtensions.isInWirkrichtungOfSignal((TopGraph)topGraph, (Signal)signal, (Punkt_Objekt)pzb);
            _xifexpression = _isInWirkrichtungOfSignal ? "+" : "-";
            String directionSign = _xifexpression;
            String _xifexpression_1 = null;
            if (distance == 0L) {
                _xifexpression_1 = Long.valueOf(distance).toString();
            } else {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(directionSign);
                String _string = Long.valueOf(distance).toString();
                _builder.append(_string);
                _xifexpression_1 = _builder.toString();
            }
            return _xifexpression_1;
        }
        Functions.Function1 _function = it -> {
            ID_Signal_TypeClass _iDSignal = it.getIDSignal();
            Signal _value = null;
            if (_iDSignal != null) {
                _value = _iDSignal.getValue();
            }
            return _value == signal;
        };
        Iterable bueSpezifischesSignal = org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)signal).getBUESpezifischesSignal(), (Functions.Function1)_function);
        boolean _isEmpty = org.eclipse.xtext.xbase.lib.IterableExtensions.isEmpty((Iterable)bueSpezifischesSignal);
        if (_isEmpty) {
            return "";
        }
        Functions.Function1 _function_1 = kante -> {
            Functions.Function1 _function_2 = it -> it.getIDBUEAnlage();
            Functions.Function1 _function_3 = it -> {
                ID_BUE_Anlage_ohne_Proxy_TypeClass _iDBUEAnlage = kante.getIDBUEAnlage();
                return it == _iDBUEAnlage;
            };
            return org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)bueSpezifischesSignal, (Functions.Function1)_function_2), (Functions.Function1)_function_3);
        };
        Iterable bueKantens = org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)signal).getBUEKante(), (Functions.Function1)_function_1);
        boolean _isEmpty_1 = org.eclipse.xtext.xbase.lib.IterableExtensions.isEmpty((Iterable)bueKantens);
        if (_isEmpty_1) {
            return "";
        }
        return this.getDistanceOfPoints(bueKantens, (Punkt_Objekt)pzb);
    }

    private String _getDistanceSignalTrackSwitch(TopGraph topGraph, PZB_Element pzb, W_Kr_Gsp_Element gspElement) {
        Functions.Function1 _function = it -> {
            Zungenpaar_AttributeGroup _zungenpaar = it.getZungenpaar();
            return _zungenpaar != null;
        };
        Iterable gspKomponent = org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)WKrGspElementExtensions.getWKrGspKomponenten((W_Kr_Gsp_Element)gspElement), (Functions.Function1)_function);
        boolean _isEmpty = org.eclipse.xtext.xbase.lib.IterableExtensions.isEmpty((Iterable)gspKomponent);
        if (_isEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            Bezeichnung_Element_AttributeGroup _bezeichnung = null;
            if (gspElement != null) {
                _bezeichnung = gspElement.getBezeichnung();
            }
            Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
            String _wert = null;
            if (_bezeichnungTabelle != null) {
                _wert = _bezeichnungTabelle.getWert();
            }
            _builder.append(_wert);
            _builder.append(" hast no Zungenpaar");
            throw new IllegalArgumentException(_builder.toString());
        }
        return this.getDistanceOfPoints(gspKomponent, (Punkt_Objekt)pzb);
    }

    private String getDistanceOfPoints(Iterable<? extends Punkt_Objekt> p1s, Punkt_Objekt p2) {
        Double distance;
        double _doubleValue;
        boolean _tripleEquals;
        Double _fold = null;
        if (p1s != null) {
            Functions.Function2 _function = (current, p1) -> Math.min(current, (Double)org.eclipse.xtext.xbase.lib.IterableExtensions.min(this.getPointsDistance((Punkt_Objekt)p1, p2)));
            _fold = (Double)org.eclipse.xtext.xbase.lib.IterableExtensions.fold(p1s, (Object)Double.MAX_VALUE, (Functions.Function2)_function);
        }
        boolean bl = _tripleEquals = (_doubleValue = (distance = _fold).doubleValue()) == 0.0;
        if (_tripleEquals) {
            return "";
        }
        return Long.valueOf(AgateRounding.roundDown((double)distance)).toString();
    }

    private Iterable<Double> getPointsDistance(Punkt_Objekt p1, Punkt_Objekt p2) {
        Functions.Function1 _function = it -> new TopPoint(it);
        List points1 = ListExtensions.map((List)PunktObjektExtensions.getSinglePoints((Punkt_Objekt)p1), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> new TopPoint(it);
        List points2 = ListExtensions.map((List)PunktObjektExtensions.getSinglePoints((Punkt_Objekt)p2), (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = pa -> {
            Functions.Function1 _function_3 = pb -> this.topGraphService.findShortestDistance(pa, pb);
            return ListExtensions.map((List)points2, (Functions.Function1)_function_3);
        };
        Functions.Function1 _function_3 = it -> it.isPresent();
        Functions.Function1 _function_4 = it -> ((BigDecimal)it.get()).doubleValue();
        return org.eclipse.xtext.xbase.lib.IterableExtensions.toList((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.flatMap((Iterable)points1, (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4));
    }

    @XbaseGenerated
    public static String fillBezugsElement(Basis_Objekt object) {
        if (object instanceof Signal) {
            return SskpTransformator._fillBezugsElement((Signal)object);
        }
        if (object instanceof W_Kr_Gsp_Element) {
            return SskpTransformator._fillBezugsElement((W_Kr_Gsp_Element)object);
        }
        if (object != null) {
            return SskpTransformator._fillBezugsElement(object);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(object).toString());
    }

    @XbaseGenerated
    private String getDistanceSignalTrackSwitch(TopGraph topGraph, PZB_Element pzb, Basis_Objekt signal) {
        if (signal instanceof Signal) {
            return this._getDistanceSignalTrackSwitch(topGraph, pzb, (Signal)signal);
        }
        if (signal instanceof W_Kr_Gsp_Element) {
            return this._getDistanceSignalTrackSwitch(topGraph, pzb, (W_Kr_Gsp_Element)signal);
        }
        if (signal != null) {
            return this._getDistanceSignalTrackSwitch(topGraph, pzb, signal);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(topGraph, pzb, signal).toString());
    }
}

