/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table;

import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.ContextualDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDisplayConverter;
import org.eclipse.nebula.widgets.nattable.freeze.CompositeFreezeLayer;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeHelper;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeLayer;
import org.eclipse.nebula.widgets.nattable.freeze.command.FreezeColumnStrategy;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.search.config.DefaultSearchBindings;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.config.DefaultMoveSelectionConfiguration;
import org.eclipse.nebula.widgets.nattable.selection.config.DefaultSelectionLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.selection.config.RowOnlySelectionBindings;
import org.eclipse.nebula.widgets.nattable.selection.config.RowOnlySelectionConfiguration;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;

public class BodyLayerStack
extends AbstractLayerTransform {
    private IDataProvider stackBodyDataProvider;
    protected SelectionLayer selectionLayer;
    private ViewportLayer viewportLayer;
    private FreezeLayer freezeLayer;
    protected DataLayer bodyDataLayer;

    public BodyLayerStack(DataLayer bodyDataLayer) {
        this(bodyDataLayer, BodyLayerStack.createSelectionLayer((IUniqueIndexLayer)bodyDataLayer));
    }

    public BodyLayerStack(DataLayer bodyDataLayer, TreeLayer treeLayer) {
        this(bodyDataLayer, BodyLayerStack.createSelectionLayer((IUniqueIndexLayer)treeLayer));
    }

    public BodyLayerStack(DataLayer bodyDataLayer, SelectionLayer selectionLayer) {
        this.bodyDataLayer = bodyDataLayer;
        this.selectionLayer = selectionLayer;
        this.init();
    }

    private static SelectionLayer createSelectionLayer(IUniqueIndexLayer indexLayer) {
        SelectionLayer result = new SelectionLayer(indexLayer, false);
        result.addConfiguration((IConfiguration)new RowOnlySelectionBindings());
        result.addConfiguration((IConfiguration)new RowOnlySelectionConfiguration());
        result.addConfiguration((IConfiguration)new DefaultMoveSelectionConfiguration());
        result.addConfiguration((IConfiguration)new DefaultSelectionLayerConfiguration(){

            protected void addSearchUIBindings() {
            }
        });
        return result;
    }

    protected void init() {
        this.stackBodyDataProvider = this.bodyDataLayer.getDataProvider();
        this.viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
        this.freezeLayer = new FreezeLayer((IUniqueIndexLayer)this.selectionLayer);
        CompositeFreezeLayer compositeFreezeLayer = new CompositeFreezeLayer(this.freezeLayer, this.viewportLayer, this.selectionLayer);
        this.setUnderlyingLayer((ILayer)compositeFreezeLayer);
    }

    public IDataProvider getBodyDataProvider() {
        return this.stackBodyDataProvider;
    }

    public SelectionLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    public ViewportLayer getViewportLayer() {
        return this.viewportLayer;
    }

    public FreezeLayer getFreezeLayer() {
        return this.freezeLayer;
    }

    public void freezeColumn(int columnPos) {
        FreezeColumnStrategy freezeColumnStrategy = new FreezeColumnStrategy(this.freezeLayer, this.viewportLayer, columnPos);
        FreezeHelper.freeze((FreezeLayer)this.freezeLayer, (ViewportLayer)this.viewportLayer, (PositionCoordinate)freezeColumnStrategy.getTopLeftPosition(), (PositionCoordinate)freezeColumnStrategy.getBottomRightPosition());
    }

    public void freezeColumns(Set<Integer> columnsPos) {
        if (columnsPos.isEmpty()) {
            this.freezeColumn(0);
            return;
        }
        Integer maxValue = Collections.max(columnsPos);
        Integer minValue = Collections.min(columnsPos);
        FreezeColumnStrategy firstColumntoFreeze = new FreezeColumnStrategy(this.freezeLayer, this.viewportLayer, minValue.intValue());
        FreezeColumnStrategy lastColumntoFreeze = new FreezeColumnStrategy(this.freezeLayer, this.viewportLayer, maxValue.intValue());
        FreezeHelper.freeze((FreezeLayer)this.freezeLayer, (ViewportLayer)this.viewportLayer, (PositionCoordinate)firstColumntoFreeze.getTopLeftPosition(), (PositionCoordinate)lastColumntoFreeze.getBottomRightPosition());
    }

    public void addSearchConfiguration(IConfigRegistry registry, final Function<ILayerCell, String> getCellValue) {
        this.selectionLayer.addConfiguration((IConfiguration)new DefaultSearchBindings());
        ContextualDisplayConverter displayConverter = new ContextualDisplayConverter(){

            public Object displayToCanonicalValue(ILayerCell cell, IConfigRegistry configRegistry, Object displayValue) {
                if (cell.getLayer() != BodyLayerStack.this.selectionLayer) {
                    return new DefaultDisplayConverter().displayToCanonicalValue(cell, configRegistry, displayValue);
                }
                return getCellValue.apply(cell);
            }

            public Object canonicalToDisplayValue(ILayerCell cell, IConfigRegistry configRegistry, Object canonicalValue) {
                if (cell.getLayer() != BodyLayerStack.this.selectionLayer) {
                    return new DefaultDisplayConverter().canonicalToDisplayValue(cell, configRegistry, canonicalValue);
                }
                return this.displayToCanonicalValue(cell, configRegistry, canonicalValue);
            }
        };
        registry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)displayConverter, DisplayMode.NORMAL, "searchCellConverter");
    }
}

