/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table.tree;

import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.sort.command.SortColumnCommand;
import org.eclipse.nebula.widgets.nattable.sort.command.SortCommandHandler;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.set.utils.table.BodyLayerStack;
import org.eclipse.set.utils.table.TableRowData;
import org.eclipse.set.utils.table.sorting.TableSortModel;
import org.eclipse.set.utils.table.tree.TableTreeRowModel;
import org.eclipse.set.utils.table.tree.TreeDataProvider;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TreeSortCommandHandler
extends SortCommandHandler<BodyLayerStack> {
    private TreeLayer treeLayer;
    private TableSortModel sortModel;

    public TreeSortCommandHandler(TableSortModel sortModel, SortHeaderLayer<BodyLayerStack> sortHeaderLayer, TreeLayer treeLayer) {
        super((ISortModel)sortModel, sortHeaderLayer);
        this.treeLayer = treeLayer;
        this.sortModel = sortModel;
    }

    public boolean doCommand(SortColumnCommand command) {
        boolean _not;
        boolean _hasHiddenRows = this.treeLayer.hasHiddenRows();
        boolean bl = _not = !_hasHiddenRows;
        if (_not) {
            return super.doCommand(command);
        }
        Functions.Function1 _function = it -> this.sortModel.getTableData().getRowData((int)it);
        List hiddenRows = IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)this.treeLayer.getHiddenRowIndexes(), (Functions.Function1)_function)));
        this.treeLayer.expandAll();
        super.doCommand(command);
        TreeDataProvider treeData = this.getTreeDataProvider();
        if (treeData == null) {
            return true;
        }
        Functions.Function1 _function_1 = it -> treeData.getParent((TableRowData)it);
        Set parents = IterableExtensions.toSet((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)hiddenRows, (Functions.Function1)_function_1)));
        Consumer<TableRowData> _function_2 = it -> this.treeLayer.collapseTreeRow(this.sortModel.getTableData().getCurrentRowIndex((TableRowData)it));
        parents.forEach(_function_2);
        return true;
    }

    public TreeDataProvider getTreeDataProvider() {
        ITreeRowModel _model = this.treeLayer.getModel();
        if (_model instanceof TableTreeRowModel) {
            ITreeRowModel _model_1 = this.treeLayer.getModel();
            TableTreeRowModel treeRowModel = (TableTreeRowModel)_model_1;
            return treeRowModel.getTreeData();
        }
        return null;
    }
}

