/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.radial.intermediate.optimization;

import org.eclipse.elk.alg.radial.intermediate.optimization.IEvaluation;
import org.eclipse.elk.core.math.ElkMath;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.util.ElkGraphUtil;

public class EdgeLengthOptimization
implements IEvaluation {
    @Override
    public double evaluate(ElkNode root) {
        double edgeLength = 0.0;
        for (ElkEdge edge : ElkGraphUtil.allOutgoingEdges((ElkNode)root)) {
            ElkNode target = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)edge.getTargets().get(0)));
            double targetX = target.getX() + target.getWidth() / 2.0;
            double targetY = target.getY() + target.getHeight() / 2.0;
            double rootX = root.getX() + root.getWidth() / 2.0;
            double rootY = root.getY() + root.getHeight() / 2.0;
            KVector vector = new KVector();
            vector.x = targetX - rootX;
            vector.y = targetY - rootY;
            KVector sourceClip = new KVector(vector.x, vector.y);
            ElkMath.clipVector((KVector)sourceClip, (double)root.getWidth(), (double)root.getHeight());
            vector.x -= sourceClip.x;
            vector.y -= sourceClip.y;
            rootX = targetX - vector.x;
            rootY = targetY - vector.y;
            KVector targetClip = new KVector(vector.x, vector.y);
            ElkMath.clipVector((KVector)targetClip, (double)target.getWidth(), (double)target.getHeight());
            vector.x -= targetClip.x;
            vector.y -= targetClip.y;
            targetX = rootX + vector.x;
            targetY = rootY + vector.y;
            double vectorX = targetX - rootX;
            double vectorY = targetY - rootY;
            edgeLength += Math.sqrt(vectorX * vectorX + vectorY * vectorY);
        }
        return edgeLength;
    }
}

