/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.debug.grandom.gRandom;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConstraintType implements Enumerator
{
    FREE(0, "free", "free"),
    SIDE(1, "side", "side"),
    POSITION(2, "position", "position"),
    ORDER(3, "order", "order"),
    RATIO(4, "ratio", "ratio");

    public static final int FREE_VALUE = 0;
    public static final int SIDE_VALUE = 1;
    public static final int POSITION_VALUE = 2;
    public static final int ORDER_VALUE = 3;
    public static final int RATIO_VALUE = 4;
    private static final ConstraintType[] VALUES_ARRAY;
    public static final List<ConstraintType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConstraintType[]{FREE, SIDE, POSITION, ORDER, RATIO};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConstraintType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConstraintType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConstraintType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConstraintType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConstraintType get(int value) {
        switch (value) {
            case 0: {
                return FREE;
            }
            case 1: {
                return SIDE;
            }
            case 2: {
                return POSITION;
            }
            case 3: {
                return ORDER;
            }
            case 4: {
                return RATIO;
            }
        }
        return null;
    }

    private ConstraintType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

