/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.validation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.validation.GraphIssue;
import org.eclipse.elk.core.validation.IValidatingGraphElementVisitor;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.util.ElkGraphUtil;

public class GraphValidator
implements IValidatingGraphElementVisitor {
    private final List<GraphIssue> issues = new ArrayList<GraphIssue>();
    private final Map<LayoutAlgorithmData, IValidatingGraphElementVisitor> algorithmSpecificValidators = new HashMap<LayoutAlgorithmData, IValidatingGraphElementVisitor>();

    @Override
    public void visit(ElkGraphElement element) {
        ElkNode parent;
        if (element instanceof ElkEdge) {
            this.checkEdge((ElkEdge)element);
        }
        if ((parent = ElkGraphUtil.containingGraph((ElkGraphElement)element)) != null) {
            this.runAlgorithmSpecificChecks(element, parent);
        }
        if (element instanceof ElkNode && (parent == null || parent.getProperty(CoreOptions.RESOLVED_ALGORITHM) != element.getProperty(CoreOptions.RESOLVED_ALGORITHM))) {
            this.runAlgorithmSpecificChecks(element, (ElkNode)element);
        }
    }

    protected void checkEdge(ElkEdge edge) {
        if (!edge.isConnected()) {
            this.issues.add(new GraphIssue((ElkGraphElement)edge, "Edge is not connected.", GraphIssue.Severity.ERROR));
        } else {
            ElkNode bestContainer = ElkGraphUtil.findBestEdgeContainment((ElkEdge)edge);
            if (bestContainer != null && bestContainer != edge.getContainingNode()) {
                StringBuilder message = new StringBuilder("Edge should be contained in ");
                ElkUtil.printElementPath((ElkGraphElement)bestContainer, message);
                this.issues.add(new GraphIssue((ElkGraphElement)edge, message.toString(), GraphIssue.Severity.WARNING));
            }
        }
        for (ElkEdgeSection edgeSection : edge.getSections()) {
            String message;
            ElkConnectableShape outgoingShape;
            ElkConnectableShape incomingShape = edgeSection.getIncomingShape();
            if (incomingShape != null) {
                String message2;
                if (!edge.getSources().contains((Object)incomingShape)) {
                    message2 = String.valueOf(incomingShape.eClass().getName()) + " declared as incoming shape is not a source of this edge.";
                    this.issues.add(new GraphIssue((ElkGraphElement)edge, message2, GraphIssue.Severity.ERROR));
                }
                if (!edgeSection.getIncomingSections().isEmpty()) {
                    message2 = "An edge section cannot be connected to an " + incomingShape.eClass().getName() + " and other sections at the same time.";
                    this.issues.add(new GraphIssue((ElkGraphElement)edge, message2, GraphIssue.Severity.ERROR));
                }
            }
            if ((outgoingShape = edgeSection.getOutgoingShape()) == null) continue;
            if (!edge.getTargets().contains((Object)outgoingShape)) {
                message = String.valueOf(outgoingShape.eClass().getName()) + " declared as outgoing shape is not a target of this edge.";
                this.issues.add(new GraphIssue((ElkGraphElement)edge, message, GraphIssue.Severity.ERROR));
            }
            if (edgeSection.getOutgoingSections().isEmpty()) continue;
            message = "An edge section cannot be connected to an " + outgoingShape.eClass().getName() + " and other sections at the same time.";
            this.issues.add(new GraphIssue((ElkGraphElement)edge, message, GraphIssue.Severity.ERROR));
        }
    }

    protected void runAlgorithmSpecificChecks(ElkGraphElement element, ElkNode parent) {
        IValidatingGraphElementVisitor validator;
        LayoutAlgorithmData algoData = (LayoutAlgorithmData)parent.getProperty(CoreOptions.RESOLVED_ALGORITHM);
        if (algoData != null && (validator = this.getValidator(algoData)) != null) {
            validator.visit(element);
        }
    }

    protected IValidatingGraphElementVisitor getValidator(LayoutAlgorithmData algoData) {
        IValidatingGraphElementVisitor validator = this.algorithmSpecificValidators.get(algoData);
        if (validator != null) {
            return validator;
        }
        Class<? extends IValidatingGraphElementVisitor> validatorClass = algoData.getValidatorClass();
        if (validatorClass == null) {
            return null;
        }
        try {
            validator = validatorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.algorithmSpecificValidators.put(algoData, validator);
            return validator;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException("Failed to instantiate validator for " + algoData.getId(), ex);
        }
    }

    public List<GraphIssue> getIssues() {
        if (this.algorithmSpecificValidators.isEmpty()) {
            return this.issues;
        }
        ArrayList<GraphIssue> result = new ArrayList<GraphIssue>();
        result.addAll(this.issues);
        for (IValidatingGraphElementVisitor validator : this.algorithmSpecificValidators.values()) {
            result.addAll(validator.getIssues());
        }
        return result;
    }
}

