/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.representation;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.business.api.session.danalysis.DRepresentationLocationRule;
import org.eclipse.sirius.business.internal.representation.DRepresentationLocationRuleRegistry;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;

public class DRepresentationLocationRuleRegistryListener
implements IRegistryEventListener {
    public static final String REP_LOCATION_RULE_EXTENSION_POINT = "org.eclipse.sirius.dRepresentationLocationRule";
    private static final String REP_LOCATION_RULE_TAG_EXTENSION = "dRepresentationLocationRule";
    private static final String REP_LOCATION_RULE_CLASS_ATTRIBUTE = "class";
    private static final String REP_LOCATION_RULE_CLASS_PRIORITY = "priority";

    public void init() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addListener((IRegistryEventListener)this, REP_LOCATION_RULE_EXTENSION_POINT);
        this.parseInitialContributions();
    }

    public void added(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void removed(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement elem = iConfigurationElementArray[n4];
                if (REP_LOCATION_RULE_TAG_EXTENSION.equals(elem.getName())) {
                    String extensionClassName = elem.getAttribute(REP_LOCATION_RULE_CLASS_ATTRIBUTE);
                    Set<DRepresentationLocationRule> repLocationRules = DRepresentationLocationRuleRegistry.getInstance().getRepLocationRules();
                    for (DRepresentationLocationRule repLocationRule : repLocationRules) {
                        if (!extensionClassName.equals(repLocationRule.getClass().getName())) continue;
                        DRepresentationLocationRuleRegistry.getInstance().removeRepLocationRule(repLocationRule);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    public void parseInitialContributions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = registry.getExtensionPoint(REP_LOCATION_RULE_EXTENSION_POINT).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    private void parseExtension(IExtension extension) {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            try {
                Object contribution = elem.createExecutableExtension(REP_LOCATION_RULE_CLASS_ATTRIBUTE);
                if (contribution instanceof DRepresentationLocationRule) {
                    String priorityStr = elem.getAttribute(REP_LOCATION_RULE_CLASS_PRIORITY);
                    DRepresentationLocationRuleRegistry.Priority priority = DRepresentationLocationRuleRegistry.Priority.valueOf(priorityStr.toUpperCase());
                    DRepresentationLocationRuleRegistry.getInstance().addRepLocationRule((DRepresentationLocationRule)contribution, priority);
                }
            }
            catch (IllegalArgumentException | NullPointerException | CoreException e) {
                SiriusPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius", Messages.AbstractSiriusMigrationService_contributionInstantiationErrorMsg, e));
            }
            ++n2;
        }
    }

    public void dispose() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.removeListener((IRegistryEventListener)this);
        DRepresentationLocationRuleRegistry.getInstance().dispose();
    }
}

