/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.p2packing;

import java.util.List;
import org.eclipse.elk.alg.rectpacking.RectPackingLayoutPhases;
import org.eclipse.elk.alg.rectpacking.options.InternalProperties;
import org.eclipse.elk.alg.rectpacking.options.RectPackingOptions;
import org.eclipse.elk.alg.rectpacking.p2packing.RowFillingAndCompaction;
import org.eclipse.elk.alg.rectpacking.util.DrawingData;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkGraphFactory;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.emf.common.util.EList;

public class Compactor
implements ILayoutPhase<RectPackingLayoutPhases, ElkNode> {
    public void process(ElkNode graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Compaction", 1.0f);
        EList rectangles = graph.getChildren();
        double aspectRatio = (Double)graph.getProperty(RectPackingOptions.ASPECT_RATIO);
        double nodeNodeSpacing = (Double)graph.getProperty(RectPackingOptions.SPACING_NODE_NODE);
        ElkPadding padding = (ElkPadding)graph.getProperty(RectPackingOptions.PADDING);
        RowFillingAndCompaction secondIt = new RowFillingAndCompaction(aspectRatio, nodeNodeSpacing);
        DrawingData drawing = secondIt.start((List<ElkNode>)rectangles, progressMonitor, graph, padding);
        if (progressMonitor.isLoggingEnabled()) {
            progressMonitor.logGraph(graph, "Compacted");
        }
        this.copyRowWidthChangeValues(graph, secondIt);
        int iterations = (Integer)graph.getProperty(RectPackingOptions.PACKING_COMPACTION_ITERATIONS);
        while (iterations > 1) {
            double newSM;
            ElkNode clone = this.clone(graph);
            double oldSM = drawing.getScaleMeasure();
            this.configureSecondIteration(graph, clone, drawing);
            secondIt = new RowFillingAndCompaction(aspectRatio, nodeNodeSpacing);
            DrawingData newDrawing = secondIt.start((List<ElkNode>)rectangles, progressMonitor, clone, padding);
            if (progressMonitor.isLoggingEnabled()) {
                progressMonitor.logGraph(clone, "Layouted clone " + iterations);
            }
            if ((newSM = newDrawing.getScaleMeasure()) >= oldSM && newSM == newSM) {
                int i = 0;
                while (i < clone.getChildren().size()) {
                    this.copyPosition((ElkNode)clone.getChildren().get(i), (ElkNode)graph.getChildren().get(i));
                    ++i;
                }
                this.copyRowWidthChangeValues(graph, secondIt);
                drawing.setDrawingWidth(newDrawing.getDrawingWidth());
                drawing.setDrawingHeight(newDrawing.getDrawingHeight());
            }
            --iterations;
        }
        graph.setProperty(InternalProperties.DRAWING_HEIGHT, (Object)drawing.getDrawingHeight());
        graph.setProperty(InternalProperties.DRAWING_WIDTH, (Object)drawing.getDrawingWidth());
        progressMonitor.done();
    }

    private void copyRowWidthChangeValues(ElkNode graph, RowFillingAndCompaction compaction) {
        graph.setProperty(InternalProperties.MIN_ROW_INCREASE, (Object)compaction.potentialRowWidthIncreaseMin);
        graph.setProperty(InternalProperties.MAX_ROW_INCREASE, (Object)compaction.potentialRowWidthIncreaseMax);
        graph.setProperty(InternalProperties.MIN_ROW_DECREASE, (Object)compaction.potentialRowWidthDecreaseMin);
        graph.setProperty(InternalProperties.MAX_ROW_DECREASE, (Object)compaction.potentialRowWidthDecreaseMax);
    }

    public LayoutProcessorConfiguration<RectPackingLayoutPhases, ElkNode> getLayoutProcessorConfiguration(ElkNode graph) {
        return null;
    }

    private void configureSecondIteration(ElkNode layoutGraph, ElkNode clone, DrawingData drawing) {
        ElkPadding padding = (ElkPadding)layoutGraph.getProperty(RectPackingOptions.PADDING);
        double aspectRatio = (Double)layoutGraph.getProperty(RectPackingOptions.ASPECT_RATIO);
        if (layoutGraph.getChildren().size() > 1 && (Double)layoutGraph.getProperty(InternalProperties.MIN_ROW_INCREASE) != Double.POSITIVE_INFINITY && (drawing.getDrawingWidth() + padding.getHorizontal()) / (drawing.getDrawingHeight() + padding.getVertical()) < aspectRatio) {
            clone.setProperty(InternalProperties.TARGET_WIDTH, (Object)((Double)layoutGraph.getProperty(InternalProperties.TARGET_WIDTH) + (Double)layoutGraph.getProperty(InternalProperties.MIN_ROW_INCREASE)));
        } else if (layoutGraph.getChildren().size() > 1 && (Double)layoutGraph.getProperty(InternalProperties.MIN_ROW_DECREASE) != Double.POSITIVE_INFINITY && (drawing.getDrawingWidth() + padding.getHorizontal()) / (drawing.getDrawingHeight() + padding.getVertical()) > aspectRatio) {
            clone.setProperty(InternalProperties.TARGET_WIDTH, (Object)Math.max((Double)layoutGraph.getProperty(InternalProperties.MIN_WIDTH), (Double)clone.getProperty(InternalProperties.TARGET_WIDTH) - (Double)layoutGraph.getProperty(InternalProperties.MIN_ROW_DECREASE)));
        }
    }

    private ElkNode clone(ElkNode node) {
        ElkNode clone = ElkGraphFactory.eINSTANCE.createElkNode();
        clone.copyProperties((IPropertyHolder)node);
        for (ElkNode child : node.getChildren()) {
            ElkNode newChild = ElkGraphFactory.eINSTANCE.createElkNode();
            newChild.setParent(clone);
            newChild.setDimensions(child.getWidth(), child.getHeight());
            newChild.setIdentifier(child.getIdentifier());
            newChild.setLocation(child.getX(), child.getY());
            clone.getChildren().add((Object)newChild);
            newChild.copyProperties((IPropertyHolder)child);
        }
        return clone;
    }

    private void copyPosition(ElkNode node, ElkNode other) {
        other.setDimensions(node.getWidth(), node.getHeight());
        other.setLocation(node.getX(), node.getY());
        int i = 0;
        while (i < node.getChildren().size()) {
            this.copyPosition((ElkNode)node.getChildren().get(i), (ElkNode)other.getChildren().get(i));
            ++i;
        }
    }
}

