/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.view;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.ObjectAdapter;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.LayoutHelper;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.IInternalLayoutRunnable;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.LayoutNode;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.LayoutService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.view.AbstractLayoutData;
import org.eclipse.sirius.diagram.ui.business.internal.view.EdgeLabelLayoutData;
import org.eclipse.sirius.diagram.ui.business.internal.view.EdgeLayoutData;
import org.eclipse.sirius.diagram.ui.business.internal.view.LayoutData;
import org.eclipse.sirius.diagram.ui.business.internal.view.RootLayoutData;
import org.eclipse.sirius.diagram.ui.business.internal.view.SiriusLayoutDataFlusher;
import org.eclipse.sirius.diagram.ui.graphical.figures.SiriusLayoutHelper;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.BorderItemAwareLayoutProvider;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public final class SiriusLayoutDataManagerImpl
implements SiriusLayoutDataManager {
    private static final Adapter LAYOUT_MARKER_ADAPTER = new Adapter(){

        public void setTarget(Notifier newTarget) {
        }

        public void notifyChanged(Notification notification) {
        }

        public boolean isAdapterForType(Object type) {
            return type instanceof SiriusLayoutDataManager;
        }

        public Notifier getTarget() {
            return null;
        }
    };
    private static final Adapter LAYOUT_MARKER_ADAPTER_ON_OPENING = new Adapter(){

        public void setTarget(Notifier newTarget) {
        }

        public void notifyChanged(Notification notification) {
        }

        public boolean isAdapterForType(Object type) {
            return type instanceof SiriusLayoutDataManager;
        }

        public Notifier getTarget() {
            return null;
        }
    };
    private static final Adapter CENTER_LAYOUT_MARKER_ADAPTER = new Adapter(){

        public void setTarget(Notifier newTarget) {
        }

        public void notifyChanged(Notification notification) {
        }

        public boolean isAdapterForType(Object type) {
            return type instanceof SiriusLayoutDataManager;
        }

        public Notifier getTarget() {
            return null;
        }
    };
    private static final Adapter REFERENCE_LAYOUT_MARKER_ADAPTER = new Adapter(){

        public void setTarget(Notifier newTarget) {
        }

        public void notifyChanged(Notification notification) {
        }

        public boolean isAdapterForType(Object type) {
            return type instanceof SiriusLayoutDataManager;
        }

        public Notifier getTarget() {
            return null;
        }
    };
    private static final Adapter BORDER_NODE_LAYOUT_MARKER_ADAPTER = new Adapter(){

        public void setTarget(Notifier newTarget) {
        }

        public void notifyChanged(Notification notification) {
        }

        public boolean isAdapterForType(Object type) {
            return type instanceof SiriusLayoutDataManager;
        }

        public Notifier getTarget() {
            return null;
        }
    };
    List<AbstractLayoutData> rootsLayoutData = new ArrayList<AbstractLayoutData>();
    Predicate<View> predicate = new Predicate<View>(){

        public boolean apply(View input) {
            return SiriusLayoutDataManagerImpl.this.hasToArrange(input);
        }
    };
    private Map<Diagram, Set<View>> createdViewForLayoutAll = new HashMap<Diagram, Set<View>>();
    private IOperationHistoryListener viewPointLayoutDataFlusher;
    private boolean ignoreConsumeState;
    private Map<Diagram, Set<View>> createdViewForInitPositionLayout = new HashMap<Diagram, Set<View>>();
    private Map<Diagram, Set<View>> createdViewAsReferenceLayout = new HashMap<Diagram, Set<View>>();
    private Map<Diagram, Set<View>> createdViewForBorderNodeLayout = new HashMap<Diagram, Set<View>>();

    private SiriusLayoutDataManagerImpl() {
        OperationHistoryFactory.getOperationHistory().addOperationHistoryListener(this.getSiriusLayoutDataFlusher());
    }

    public static SiriusLayoutDataManager init() {
        return new SiriusLayoutDataManagerImpl();
    }

    @Override
    public void addData(AbstractLayoutData aLayoutData) {
        Iterator<AbstractLayoutData> iterator = this.rootsLayoutData.iterator();
        while (iterator.hasNext()) {
            AbstractLayoutData existingRootLayoutData = iterator.next();
            if (!(existingRootLayoutData instanceof LayoutData) || !(aLayoutData instanceof LayoutData)) continue;
            LayoutData existingLayoutData = (LayoutData)existingRootLayoutData;
            LayoutData aLayoutDataInParam = (LayoutData)aLayoutData;
            if (!existingLayoutData.getTarget().equals(aLayoutDataInParam.getTarget())) continue;
            iterator.remove();
        }
        this.rootsLayoutData.add(aLayoutData);
    }

    @Override
    public LayoutData getData(AbstractDNode node, boolean searchParent) {
        AbstractLayoutData result = null;
        if (node != null) {
            AbstractDNode searchNode = node;
            if (searchParent) {
                if (node.eContainer() instanceof AbstractDNode) {
                    searchNode = (AbstractDNode)node.eContainer();
                } else if (node.eContainer() instanceof DDiagram) {
                    result = this.getData((DDiagram)node.eContainer());
                } else {
                    DiagramPlugin.getDefault().logWarning(MessageFormat.format(Messages.SiriusLayoutDataManagerImpl_unhandledContainerKind, node.eContainer().getClass().getName()));
                }
            }
            if (result == null) {
                for (AbstractLayoutData abstractLayoutData : this.rootsLayoutData) {
                    LayoutData layoutData;
                    if (abstractLayoutData instanceof LayoutData && (result = (layoutData = (LayoutData)abstractLayoutData).getData(searchNode, this.ignoreConsumeState)) != null) break;
                }
            }
            if (result == null) {
                result = this.getLayoutDataFromEdgeLayoutData(searchNode);
            }
        }
        if (result != null) {
            result.setConsume(true);
        }
        return result;
    }

    private LayoutData getLayoutDataFromEdgeLayoutData(AbstractDNode searchNode) {
        LayoutData result = null;
        for (AbstractLayoutData abstractLayoutData : this.rootsLayoutData) {
            EdgeLayoutData edgeLayoutData;
            EdgeLayoutData edgeLayoutDataBN;
            if (abstractLayoutData instanceof EdgeLayoutData && ((edgeLayoutDataBN = (edgeLayoutData = (EdgeLayoutData)abstractLayoutData).getEdgeLayoutDataForBorderNodes()) != null && (result = this.getLayoutDataFromEdgeLayoutData(edgeLayoutDataBN, searchNode)) != null || (result = this.getLayoutDataFromEdgeLayoutData(edgeLayoutData, searchNode)) != null)) break;
        }
        return result;
    }

    private LayoutData getLayoutDataFromEdgeLayoutData(EdgeLayoutData edgeLayoutData, AbstractDNode searchNode) {
        LayoutData result = null;
        if (edgeLayoutData != null) {
            LayoutData edgeTargetLayoutData;
            LayoutData edgeSourceLayoutData = edgeLayoutData.getEdgeSourceLayoutData();
            if (edgeSourceLayoutData != null) {
                result = edgeSourceLayoutData.getData(searchNode, this.ignoreConsumeState);
            }
            if (result == null && (edgeTargetLayoutData = edgeLayoutData.getEdgeTargetLayoutData()) != null) {
                result = edgeTargetLayoutData.getData(searchNode, this.ignoreConsumeState);
            }
        }
        return result;
    }

    @Override
    public EdgeLayoutData getData(DEdge edge, boolean searchParent) {
        Option noEdgeLayoutData = Options.newNone();
        return this.getData(edge, searchParent, (Option<EdgeLayoutData>)noEdgeLayoutData);
    }

    @Override
    public EdgeLayoutData getOppositeEdgeLayoutData(EdgeLayoutData edgeLayoutData, boolean searchParent) {
        DEdge edge = edgeLayoutData.getTarget();
        if (edge == null) {
            return null;
        }
        return this.getData(edge, searchParent, (Option<EdgeLayoutData>)Options.newSome((Object)edgeLayoutData));
    }

    private EdgeLayoutData getData(DEdge edge, boolean searchParent, Option<EdgeLayoutData> optionalOppositeEdgeLayoutData) {
        AbstractLayoutData result = null;
        if (result == null) {
            for (AbstractLayoutData abstractLayoutData : this.rootsLayoutData) {
                if (abstractLayoutData instanceof LayoutData) {
                    LayoutData layoutData = (LayoutData)abstractLayoutData;
                    result = layoutData.getData(edge, this.ignoreConsumeState);
                    if (result == null || optionalOppositeEdgeLayoutData.some() && ((EdgeLayoutData)optionalOppositeEdgeLayoutData.get()).equals(result)) continue;
                    break;
                }
                if (!(abstractLayoutData instanceof EdgeLayoutData) || optionalOppositeEdgeLayoutData.some() && ((EdgeLayoutData)optionalOppositeEdgeLayoutData.get()).equals(abstractLayoutData)) continue;
                EdgeLayoutData edgeLayoutData = (EdgeLayoutData)abstractLayoutData;
                EdgeTarget edgeSource = edge.getSourceNode();
                EdgeTarget edgeTarget = edge.getTargetNode();
                LayoutData edgeSourceLayoutData = edgeLayoutData.getEdgeSourceLayoutData();
                LayoutData edgeTargetLayoutData = edgeLayoutData.getEdgeTargetLayoutData();
                if (edgeSource != null && edgeSourceLayoutData instanceof RootLayoutData) {
                    RootLayoutData edgeSourceRootLayoutData = (RootLayoutData)edgeSourceLayoutData;
                    if ((this.ignoreConsumeState || !edgeSourceRootLayoutData.isConsume()) && edgeSource.equals(edgeSourceRootLayoutData.getTarget())) {
                        result = edgeLayoutData;
                        break;
                    }
                }
                if (result != null || edgeTarget == null || !(edgeTargetLayoutData instanceof RootLayoutData)) continue;
                RootLayoutData edgeTargetRootLayoutData = (RootLayoutData)edgeTargetLayoutData;
                if (!this.ignoreConsumeState && edgeTargetRootLayoutData.isConsume() || !edgeTarget.equals(edgeTargetRootLayoutData.getTarget())) continue;
                result = edgeLayoutData;
                break;
            }
        }
        if (result == null) {
            EdgeTarget targetNode;
            EdgeTarget sourceNode = edge.getSourceNode();
            if (sourceNode instanceof AbstractDNode) {
                this.getData((AbstractDNode)sourceNode);
            }
            if ((targetNode = edge.getTargetNode()) instanceof AbstractDNode) {
                this.getData((AbstractDNode)targetNode);
            }
        }
        if (result != null) {
            result.setConsume(true);
        }
        return result;
    }

    protected LayoutData getData(DDiagram diagram) {
        AbstractLayoutData result = null;
        for (AbstractLayoutData layoutData : this.rootsLayoutData) {
            if (layoutData instanceof RootLayoutData) {
                RootLayoutData rootLayoutData = (RootLayoutData)layoutData;
                result = rootLayoutData.getData(diagram, this.ignoreConsumeState);
            }
            if (result != null) break;
        }
        if (result != null) {
            result.setConsume(true);
        }
        return result;
    }

    @Override
    public LayoutData getData(AbstractDNode node) {
        return this.getData(node, false);
    }

    @Override
    public Adapter getAdapterMarker() {
        return LAYOUT_MARKER_ADAPTER;
    }

    @Override
    public Adapter getCenterAdapterMarker() {
        return CENTER_LAYOUT_MARKER_ADAPTER;
    }

    @Override
    public Adapter getReferenceAdapterMarker() {
        return REFERENCE_LAYOUT_MARKER_ADAPTER;
    }

    @Override
    public Adapter getBorderNodeMarker() {
        return BORDER_NODE_LAYOUT_MARKER_ADAPTER;
    }

    @Override
    public AbstractTransactionalCommand getAddAdapterMakerCommand(TransactionalEditingDomain domain, final IAdaptable viewAdapter) {
        return new AbstractTransactionalCommand(domain, Messages.SiriusLayoutDataManagerImpl_addLayoutMarkerCommandLabel, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View view = (View)viewAdapter.getAdapter(View.class);
                if (view != null && !view.eAdapters().contains((Object)LAYOUT_MARKER_ADAPTER)) {
                    view.eAdapters().add((Object)LAYOUT_MARKER_ADAPTER);
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    @Override
    public AbstractTransactionalCommand getAddCenterAdapterMakerCommand(TransactionalEditingDomain domain, final IAdaptable viewAdapter) {
        return new AbstractTransactionalCommand(domain, Messages.SiriusLayoutDataManagerImpl_addCenterLayoutMarkerCommandLabel, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View view = (View)viewAdapter.getAdapter(View.class);
                if (view != null && !view.eAdapters().contains((Object)CENTER_LAYOUT_MARKER_ADAPTER)) {
                    view.eAdapters().add((Object)CENTER_LAYOUT_MARKER_ADAPTER);
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    @Override
    public AbstractTransactionalCommand getAddBorderNodeMakerCommand(TransactionalEditingDomain domain, final IAdaptable viewAdapter) {
        return new AbstractTransactionalCommand(domain, Messages.SiriusLayoutDataManagerImpl_addCenterLayoutMarkerCommandLabel, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View view = (View)viewAdapter.getAdapter(View.class);
                if (view != null && !view.eAdapters().contains((Object)BORDER_NODE_LAYOUT_MARKER_ADAPTER)) {
                    view.eAdapters().add((Object)BORDER_NODE_LAYOUT_MARKER_ADAPTER);
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    @Override
    public AbstractTransactionalCommand getAddAdapterMakerOnOpeningCommand(TransactionalEditingDomain domain, final View view) {
        return new AbstractTransactionalCommand(domain, Messages.SiriusLayoutDataManagerImpl_addLayoutMarkerOnOpeningCommandLabel, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                if (view != null && !view.eAdapters().contains((Object)LAYOUT_MARKER_ADAPTER_ON_OPENING)) {
                    view.eAdapters().add((Object)LAYOUT_MARKER_ADAPTER_ON_OPENING);
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    @Override
    public EdgeLabelLayoutData getLabelData(DEdge edge) {
        EdgeLayoutData data;
        AbstractLayoutData result = null;
        if (edge != null && (data = this.getData(edge, false)) != null) {
            result = data.getEdgeLabelLayoutData();
            data.setConsume(false);
        }
        if (result != null) {
            result.setConsume(true);
        }
        return result;
    }

    @Override
    public Command getArrangeCreatedViewsCommand(List<IAdaptable> createdViews, List<IAdaptable> borderedCreatedViews, List<IAdaptable> centeredCreatedViews, List<IAdaptable> referenceChildViewsAdapters, IGraphicalEditPart host) {
        return this.getArrangeCreatedViewsCommand(createdViews, borderedCreatedViews, centeredCreatedViews, referenceChildViewsAdapters, host, false);
    }

    @Override
    public Command getArrangeCreatedViewsCommand(List<IAdaptable> createdViews, List<IAdaptable> borderedCreatedViews, List<IAdaptable> centeredCreatedViews, List<IAdaptable> referenceChildViewsAdapters, IGraphicalEditPart host, boolean useSpecificLayoutType) {
        String layoutType = useSpecificLayoutType ? "OPENING" : "DEFAULT";
        return this.getArrangeCreatedViewsCommand(createdViews, borderedCreatedViews, centeredCreatedViews, referenceChildViewsAdapters, host, layoutType);
    }

    @Override
    public Command getArrangeCreatedViewsCommand(List<IAdaptable> createdViews, List<IAdaptable> borderedCreatedViews, List<IAdaptable> centeredCreatedViews, List<IAdaptable> referenceChildViewsAdapters, IGraphicalEditPart host, String specificLayoutType) {
        CompoundCommand cc = new CompoundCommand();
        if (centeredCreatedViews != null) {
            Point previousCenterLocation = this.getReferencePosition(host, referenceChildViewsAdapters);
            List<IGraphicalEditPart> partsToLayout = centeredCreatedViews.stream().map(adaptable -> {
                View view = (View)adaptable.getAdapter(View.class);
                return (IGraphicalEditPart)host.getViewer().getEditPartRegistry().get(view);
            }).filter(Objects::nonNull).toList();
            List<IFigure> figuresToLayout = partsToLayout.stream().map(GraphicalEditPart::getFigure).toList();
            for (IGraphicalEditPart part : partsToLayout) {
                previousCenterLocation = this.calculateCenterLocation(host, cc, part, previousCenterLocation, figuresToLayout);
            }
        }
        if (createdViews != null || borderedCreatedViews != null) {
            cc.add(this.arrangeSeveralCreatedViews(createdViews, borderedCreatedViews, host, specificLayoutType));
        }
        return cc;
    }

    private IFigure adapterToFigure(IGraphicalEditPart host, IAdaptable iAdaptable) {
        IGraphicalEditPart part = (IGraphicalEditPart)host.getViewer().getEditPartRegistry().get(iAdaptable.getAdapter(View.class));
        return part.getFigure();
    }

    private Point getReferencePosition(IGraphicalEditPart host, List<IAdaptable> referenceViews) {
        if (referenceViews == null) {
            return null;
        }
        SiriusLayoutHelper layoutHelper = new SiriusLayoutHelper(host);
        return referenceViews.stream().map(adaptable -> this.adapterToFigure(host, (IAdaptable)adaptable)).max((figure1, figure2) -> figure1.getBounds().right() - figure2.getBounds().right()).map(layoutHelper::calculateNextPoint).orElse(null);
    }

    private Point calculateCenterLocation(IGraphicalEditPart host, CompoundCommand cc, IGraphicalEditPart part, Point previousCenterLocation, Collection<IFigure> figuresToLayout) {
        Point centerLocation;
        Rectangle rect = new Rectangle();
        rect.setSize(LayoutHelper.UNDEFINED.getSize());
        SiriusLayoutHelper layoutHelper = new SiriusLayoutHelper(host);
        IFigure figure = part.getFigure();
        if (previousCenterLocation == null) {
            Point referencePoint = host instanceof DiagramEditPart ? layoutHelper.getReferencePosition(host.getContentPane(), ((FigureCanvas)host.getViewer().getControl()).getViewport(), host) : new Point(20, 20);
            rect.setLocation(referencePoint);
            rect.setSize(figure.getSize());
            Point point = layoutHelper.validatePosition(host.getContentPane(), rect, figuresToLayout);
            centerLocation = point.getCopy();
        } else {
            centerLocation = previousCenterLocation;
        }
        cc.add((Command)new ICommandProxy((ICommand)new SetBoundsCommand(host.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)part, centerLocation)));
        Point figureReferencePoint = layoutHelper.determineReferencePoint(figure);
        figureReferencePoint.translate(centerLocation);
        centerLocation = layoutHelper.computeTranslatedPoint(figureReferencePoint, figure, false);
        return centerLocation.getCopy();
    }

    private Command arrangeSeveralCreatedViews(List<IAdaptable> createdViewsAdapters, List<IAdaptable> borderedCreatedViews, IGraphicalEditPart host, String specificLayoutType) {
        CompoundCommand cc = new CompoundCommand();
        if (createdViewsAdapters != null && createdViewsAdapters.size() > 0) {
            LinkedList<IAdaptable> createdViewsToLayoutAdapters = new LinkedList<IAdaptable>();
            for (IAdaptable viewAdapter : createdViewsAdapters) {
                if (!this.isAlreadyArrange(viewAdapter)) {
                    createdViewsToLayoutAdapters.add(viewAdapter);
                    continue;
                }
                this.removeAlreadyArrangeMarker(viewAdapter);
            }
            if (createdViewsToLayoutAdapters.size() > 0) {
                DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(host.getEditingDomain(), createdViewsToLayoutAdapters, host, specificLayoutType);
                cc.add((Command)new ICommandProxy((ICommand)layoutCmd));
            }
        }
        if (borderedCreatedViews != null && borderedCreatedViews.size() > 0) {
            Map editPartRegistry = host.getRoot().getViewer().getEditPartRegistry();
            List<EditPart> editPartToLayout = borderedCreatedViews.stream().map(adaptable -> (View)adaptable.getAdapter(View.class)).filter(Objects::nonNull).map(editPartRegistry::get).filter(Objects::nonNull).toList();
            BorderItemAwareLayoutProvider layoutProvider = new BorderItemAwareLayoutProvider(null, true);
            cc.add(layoutProvider.layoutEditParts(editPartToLayout, (IAdaptable)new ObjectAdapter((Object)specificLayoutType), false));
        }
        if (cc.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        return cc;
    }

    @Override
    public Command getArrangeCreatedViewsOnOpeningCommand(IGraphicalEditPart host) {
        CompoundCommand cc = new CompoundCommand(Messages.SiriusLayoutDataManagerImpl_createdViewsArrangCommandLabel);
        View containerView = (View)host.getModel();
        Command layoutCommand = this.getlayoutCommand(host, containerView);
        if (layoutCommand instanceof CompoundCommand && !((CompoundCommand)layoutCommand).isEmpty()) {
            cc.add(layoutCommand);
        }
        for (Object child : containerView.getChildren()) {
            Command cmd = this.getlayoutCommand((IGraphicalEditPart)host.getViewer().getEditPartRegistry().get(containerView), (View)child);
            if (!(cmd instanceof CompoundCommand) || ((CompoundCommand)cmd).isEmpty()) continue;
            cc.add(cmd);
        }
        if (cc.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        return cc;
    }

    private Command getlayoutCommand(IGraphicalEditPart host, View containerView) {
        CompoundCommand cc = new CompoundCommand(Messages.SiriusLayoutDataManagerImpl_createdViewsArrangCommandLabel);
        Collection createdViews = Collections2.filter((Collection)containerView.getChildren(), this.predicate);
        LinkedList<EObjectAdapter> createdViewstoLayout = new LinkedList<EObjectAdapter>();
        int size = createdViews.size();
        for (Object view : createdViews) {
            createdViewstoLayout.add(new EObjectAdapter((EObject)((View)view)));
            if (size == 1) continue;
            this.removeAlreadyArrangeMarkeronOpening((View)view);
        }
        if (!createdViewstoLayout.isEmpty() && host != null) {
            DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(host.getEditingDomain(), createdViewstoLayout, host);
            cc.add((Command)new ICommandProxy((ICommand)layoutCmd));
        }
        for (Object child : containerView.getChildren()) {
            Command cmd;
            if (host == null || !((cmd = this.getlayoutCommand((IGraphicalEditPart)host.getViewer().getEditPartRegistry().get(containerView), (View)child)) instanceof CompoundCommand) || ((CompoundCommand)cmd).isEmpty()) continue;
            cc.add(cmd);
        }
        return cc;
    }

    private boolean isAlreadyArrange(IAdaptable viewAdapter) {
        boolean alreadyArranged = false;
        View view = (View)viewAdapter.getAdapter(View.class);
        if (view != null) {
            for (Adapter adapter : view.eAdapters()) {
                if (!adapter.isAdapterForType((Object)SiriusLayoutDataManager.INSTANCE)) continue;
                alreadyArranged = true;
                break;
            }
        }
        return alreadyArranged;
    }

    private boolean hasCenterLayout(IAdaptable viewAdapter) {
        boolean centerLayout = false;
        View view = (View)viewAdapter.getAdapter(View.class);
        if (view != null) {
            for (Adapter adapter : view.eAdapters()) {
                if (!adapter.isAdapterForType((Object)SiriusLayoutDataManager.INSTANCE)) continue;
                centerLayout = true;
                break;
            }
        }
        return centerLayout;
    }

    @Override
    public boolean hasToArrange(View view) {
        boolean arranged = false;
        if (view != null) {
            for (Adapter adapter : view.eAdapters()) {
                if (!adapter.isAdapterForType((Object)SiriusLayoutDataManager.INSTANCE)) continue;
                arranged = true;
                break;
            }
        }
        return arranged;
    }

    private void removeAlreadyArrangeMarker(IAdaptable viewAdapter) {
        View view = (View)viewAdapter.getAdapter(View.class);
        if (view != null) {
            Iterator iterator = view.eAdapters().iterator();
            while (iterator.hasNext()) {
                Adapter adapter = (Adapter)iterator.next();
                if (!adapter.isAdapterForType((Object)SiriusLayoutDataManager.INSTANCE)) continue;
                iterator.remove();
                break;
            }
        }
    }

    private void removeAlreadyArrangeMarkeronOpening(View view) {
        if (view != null) {
            Iterator iterator = view.eAdapters().iterator();
            while (iterator.hasNext()) {
                Adapter adapter = (Adapter)iterator.next();
                if (!adapter.isAdapterForType((Object)SiriusLayoutDataManager.INSTANCE)) continue;
                iterator.remove();
                break;
            }
        }
    }

    @Override
    public Command getArrangeCommand(ArrangeRequest request, EditPart host) {
        Command arrangeCommand = null;
        String layoutDesc = request.getLayoutType() != null ? request.getLayoutType() : "DEFAULT";
        boolean offsetFromBoundingBox = false;
        List editparts = new ArrayList();
        if ("arrangeSelectionAction".equals(request.getType())) {
            editparts = request.getPartsToArrange();
            offsetFromBoundingBox = true;
        }
        if (!editparts.isEmpty()) {
            ArrayList<LayoutNode> nodes = new ArrayList<LayoutNode>(editparts.size());
            ListIterator li = editparts.listIterator();
            while (li.hasNext()) {
                IGraphicalEditPart ep = (IGraphicalEditPart)li.next();
                View view = ep.getNotationView();
                if (view instanceof Node) {
                    Rectangle bounds = ep.getFigure().getBounds();
                    nodes.add(new LayoutNode((Node)view, bounds.width, bounds.height));
                }
                this.removeAlreadyArrangeMarkeronOpening(view);
            }
            ArrayList<String> hints = new ArrayList<String>(2);
            hints.add(layoutDesc);
            hints.add((String)host);
            ObjectAdapter layoutHint = new ObjectAdapter(hints);
            final Runnable layoutRun = this.layoutNodes(nodes, offsetFromBoundingBox, (IAdaptable)layoutHint);
            if (layoutRun instanceof IInternalLayoutRunnable) {
                arrangeCommand = ((IInternalLayoutRunnable)layoutRun).getCommand();
            } else {
                TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)host).getEditingDomain();
                arrangeCommand = new ICommandProxy((ICommand)new AbstractTransactionalCommand(editingDomain, "", null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                        layoutRun.run();
                        return CommandResult.newOKCommandResult();
                    }
                });
            }
        }
        return arrangeCommand;
    }

    private IOperationHistoryListener getSiriusLayoutDataFlusher() {
        if (this.viewPointLayoutDataFlusher == null) {
            this.viewPointLayoutDataFlusher = new SiriusLayoutDataFlusher(this);
        }
        return this.viewPointLayoutDataFlusher;
    }

    protected void flushRootLayoutDatas() {
        this.rootsLayoutData.clear();
    }

    protected void finalize() throws Throwable {
        OperationHistoryFactory.getOperationHistory().removeOperationHistoryListener(this.viewPointLayoutDataFlusher);
        super.finalize();
    }

    public Runnable layoutNodes(List<LayoutNode> nodes, boolean offsetFromBoundingBox, IAdaptable layoutHint) {
        Runnable layoutRun = LayoutService.getInstance().layoutLayoutNodes(nodes, offsetFromBoundingBox, layoutHint);
        return layoutRun;
    }

    @Override
    public void addCreatedViewForLayoutAll(Diagram gmfDiagram, LinkedHashSet<View> createdViewsToLayout) {
        this.createdViewForLayoutAll.put(gmfDiagram, createdViewsToLayout);
    }

    @Override
    public Map<Diagram, Set<View>> getCreatedViewForLayoutAll() {
        return this.createdViewForLayoutAll;
    }

    @Override
    public void setIgnoreConsumeState(boolean ignoreConsumeState) {
        this.ignoreConsumeState = ignoreConsumeState;
    }

    @Override
    public Option<AbstractLayoutData> getData() {
        if (!this.rootsLayoutData.isEmpty()) {
            return Options.newSome((Object)this.rootsLayoutData.iterator().next());
        }
        return Options.newNone();
    }

    @Override
    public void removeLayoutViews(Diagram diagram) {
        this.createdViewForLayoutAll.remove(diagram);
        this.createdViewForInitPositionLayout.remove(diagram);
        this.createdViewAsReferenceLayout.remove(diagram);
        this.createdViewForBorderNodeLayout.remove(diagram);
    }

    @Override
    public Map<Diagram, Set<View>> getCreatedViewForInitPositionLayout() {
        return this.createdViewForInitPositionLayout;
    }

    @Override
    public void addCreatedViewForInitPositionLayout(Diagram gmfDiagram, LinkedHashSet<View> createdViewsToLayout) {
        this.createdViewForInitPositionLayout.put(gmfDiagram, createdViewsToLayout);
    }

    @Override
    public Map<Diagram, Set<View>> getCreatedViewReferenceLayout() {
        return this.createdViewAsReferenceLayout;
    }

    @Override
    public void addCreatedViewAsReferenceLayout(Diagram gmfDiagram, LinkedHashSet<View> views) {
        this.createdViewAsReferenceLayout.put(gmfDiagram, views);
    }

    @Override
    public Map<Diagram, Set<View>> getCreatedViewForBorderNodeLayout() {
        return this.createdViewForBorderNodeLayout;
    }

    @Override
    public void addCreatedViewForBorderNodeLayout(Diagram gmfDiagram, LinkedHashSet<View> views) {
        this.createdViewForBorderNodeLayout.put(gmfDiagram, views);
    }
}

