/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure.locator;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.figures.LayoutHelper;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;

public class NorthNameLocator
implements IBorderItemLocator {
    private Rectangle constraint;
    private final IFigure parentFigure;
    private int offset = 10;

    public NorthNameLocator(IFigure parentFigure) {
        this.parentFigure = parentFigure;
    }

    public NorthNameLocator(IFigure parentFigure, int offset) {
        this.parentFigure = parentFigure;
        this.offset = offset;
    }

    public int getCurrentSideOfParent() {
        return 1;
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        int x = this.getParentBorder().x + this.getParentBorder().width / 2 - this.getSize((IFigure)borderItem).width / 2;
        int y = this.getParentBorder().y - this.getSize((IFigure)borderItem).height - this.offset;
        realLocation.setLocation(new Point(x, y));
        realLocation.setSize(this.getSize(borderItem));
        return realLocation;
    }

    public void setConstraint(Rectangle constraint) {
        this.constraint = constraint;
        this.getParentFigure().revalidate();
    }

    public void relocate(IFigure target) {
        Rectangle proposed = new Rectangle(this.constraint);
        this.getParentFigure().translateToAbsolute((Translatable)proposed);
        this.constraint = this.getValidLocation(proposed, target);
        target.setSize(this.getSize(target));
        target.setLocation(this.constraint.getLocation());
    }

    public IFigure getParentFigure() {
        return this.parentFigure;
    }

    protected Rectangle getParentBorder() {
        Rectangle bounds = new Rectangle(this.getParentFigure().getBounds());
        if (this.getParentFigure() instanceof NodeFigure) {
            bounds = new Rectangle(((NodeFigure)this.getParentFigure()).getHandleBounds());
        }
        return bounds;
    }

    protected final Dimension getSize(IFigure borderItem) {
        Dimension size = LayoutHelper.UNDEFINED.getSize();
        if (this.constraint != null) {
            size = this.constraint.getSize();
        }
        if (LayoutHelper.UNDEFINED.getSize().equals((Object)size)) {
            size = borderItem.getPreferredSize();
        }
        return size;
    }
}

