/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.render;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.PartPositionInfo;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramImageGenerator;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.graphics.RenderedMapModeGraphics;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.render.SiriusGraphicsSVG;
import org.eclipse.sirius.diagram.ui.tools.internal.render.SiriusGraphicsToGraphics2DAdaptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class SiriusDiagramImageGenerator
extends DiagramImageGenerator {
    private double factor = 1.0;
    private IFigure overlayFigure;

    public SiriusDiagramImageGenerator(DiagramEditPart diagramEditPart) {
        super(diagramEditPart);
        if (diagramEditPart instanceof DDiagramEditPart) {
            this.overlayFigure = ((DDiagramEditPart)diagramEditPart).getOverlayFigure();
        }
    }

    public Image createAWTImageForParts(List selectedObjects, org.eclipse.swt.graphics.Rectangle sourceRect) {
        BufferedImage awtImage = null;
        IMapMode mm = this.getMapMode();
        PrecisionRectangle rect = new PrecisionRectangle();
        rect.setX(sourceRect.x);
        rect.setY(sourceRect.y);
        rect.setWidth(sourceRect.width);
        rect.setHeight(sourceRect.height);
        mm.LPtoDP((Translatable)rect);
        awtImage = new BufferedImage((int)Math.round(rect.preciseWidth()), (int)Math.rint(rect.preciseHeight()), 7);
        Graphics2D g2d = awtImage.createGraphics();
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, awtImage.getWidth(), awtImage.getHeight());
        g2d.scale(this.factor, this.factor);
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getDiagramEditPart().getDiagramPreferencesHint().getPreferenceStore();
        if (preferenceStore.getBoolean("Global.enableAntiAlias")) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        g2d.clip(new java.awt.Rectangle(0, 0, awtImage.getWidth(), awtImage.getHeight()));
        SiriusGraphicsToGraphics2DAdaptor graphics = new SiriusGraphicsToGraphics2DAdaptor(g2d, (Rectangle)new PrecisionRectangle(0.0, 0.0, (double)rect.width / this.factor, (double)rect.height / this.factor));
        RenderedMapModeGraphics mapModeGraphics = new RenderedMapModeGraphics((Graphics)graphics, mm);
        this.renderToGraphics((Graphics)mapModeGraphics, new Point(sourceRect.x, sourceRect.y), selectedObjects);
        graphics.dispose();
        g2d.dispose();
        return awtImage;
    }

    protected void renderToGraphics(Graphics graphics, Point translateOffset, List editparts) {
        IFigure figure;
        graphics.translate(-translateOffset.x, -translateOffset.y);
        graphics.pushState();
        LinkedList<IGraphicalEditPart> connectionsToPaint = new LinkedList<IGraphicalEditPart>();
        Map decorations = this.findDecorations(editparts);
        ListIterator editPartsItr = editparts.listIterator();
        while (editPartsItr.hasNext()) {
            IGraphicalEditPart iGraphicalEditPart = (IGraphicalEditPart)editPartsItr.next();
            if (iGraphicalEditPart instanceof ConnectionEditPart) {
                connectionsToPaint.add(iGraphicalEditPart);
                continue;
            }
            connectionsToPaint.addAll(this.findConnectionsToPaint(iGraphicalEditPart));
            figure = iGraphicalEditPart.getFigure();
            this.setCurrentId(graphics, (org.eclipse.gef.GraphicalEditPart)iGraphicalEditPart);
            this.paintFigure(graphics, figure);
            this.paintDecorations(graphics, figure, decorations);
        }
        decorations = this.findDecorations(connectionsToPaint);
        for (org.eclipse.gef.GraphicalEditPart graphicalEditPart : connectionsToPaint) {
            this.setCurrentId(graphics, graphicalEditPart);
            figure = graphicalEditPart.getFigure();
            this.paintFigure(graphics, figure);
            this.paintDecorations(graphics, figure, decorations);
        }
        if (this.overlayFigure != null) {
            this.paintFigure(graphics, this.overlayFigure);
        }
    }

    private void setCurrentId(Graphics gfx, org.eclipse.gef.GraphicalEditPart part) {
        if (gfx instanceof SiriusGraphicsSVG && part instanceof GraphicalEditPart) {
            SiriusGraphicsSVG sgfx = (SiriusGraphicsSVG)gfx;
            EObject o = ((GraphicalEditPart)part).resolveSemanticElement();
            if (o instanceof DSemanticDecorator) {
                o = ((DSemanticDecorator)o).getTarget();
            }
            sgfx.setCurrentId(EcoreUtil.getURI((EObject)o).toString());
        }
    }

    protected Graphics setUpGraphics(int width, int height) {
        SWTGraphics swtG = (SWTGraphics)super.setUpGraphics(width, height);
        swtG.scale(this.factor);
        swtG.setTextAntialias(1);
        return swtG;
    }

    public org.eclipse.swt.graphics.Rectangle calculateImageRectangle(List editparts) {
        org.eclipse.swt.graphics.Rectangle sourceRect = super.calculateImageRectangle(editparts);
        return new org.eclipse.swt.graphics.Rectangle(sourceRect.x, sourceRect.y, this.scaleAsInt(sourceRect.width), this.scaleAsInt(sourceRect.height));
    }

    public List getDiagramPartInfo(DiagramEditPart diagramEditPart) {
        List superResult = super.getDiagramPartInfo(diagramEditPart);
        for (Object obj : superResult) {
            if (!(obj instanceof PartPositionInfo)) continue;
            PartPositionInfo nonScaledInfo = (PartPositionInfo)obj;
            nonScaledInfo.setPartX(nonScaledInfo.getPartX());
            nonScaledInfo.setPartY(nonScaledInfo.getPartY());
            nonScaledInfo.setPartWidth(this.scaleAsInt(nonScaledInfo.getPartWidth()));
            nonScaledInfo.setPartHeight(this.scaleAsInt(nonScaledInfo.getPartHeight()));
        }
        return superResult;
    }

    private int scaleAsInt(int value) {
        return Double.valueOf((double)value * this.factor).intValue();
    }

    public void setResolutionScale(double scale) {
        this.factor = scale;
    }
}

