/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.force.stress;

import java.util.List;
import org.eclipse.elk.alg.common.NodeMicroLayout;
import org.eclipse.elk.alg.force.ComponentsProcessor;
import org.eclipse.elk.alg.force.ElkGraphImporter;
import org.eclipse.elk.alg.force.ForceLayoutProvider;
import org.eclipse.elk.alg.force.graph.FGraph;
import org.eclipse.elk.alg.force.options.StressOptions;
import org.eclipse.elk.alg.force.stress.StressMajorization;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;

public class StressLayoutProvider
extends AbstractLayoutProvider {
    private ComponentsProcessor componentsProcessor = new ComponentsProcessor();
    private StressMajorization stressMajorization = new StressMajorization();

    public void layout(ElkNode layoutGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("ELK Stress", 1.0f);
        if (!((Boolean)layoutGraph.getProperty(StressOptions.INTERACTIVE)).booleanValue()) {
            new ForceLayoutProvider().layout(layoutGraph, progressMonitor.subTask(1.0f));
        } else if (!((Boolean)layoutGraph.getProperty(StressOptions.OMIT_NODE_MICRO_LAYOUT)).booleanValue()) {
            NodeMicroLayout.forGraph((ElkNode)layoutGraph).execute();
        }
        ElkGraphImporter graphImporter = new ElkGraphImporter();
        FGraph fgraph = graphImporter.importGraph(layoutGraph);
        List<FGraph> components = this.componentsProcessor.split(fgraph);
        for (FGraph subGraph : components) {
            if (subGraph.getNodes().size() <= 1) continue;
            this.stressMajorization.initialize(subGraph);
            this.stressMajorization.execute();
            subGraph.getLabels().forEach(label -> label.refreshPosition());
        }
        fgraph = this.componentsProcessor.recombine(components);
        graphImporter.applyLayout(fgraph);
        progressMonitor.done();
    }
}

