/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.control;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.ui.tools.api.control.SiriusControlHandler;
import org.eclipse.sirius.ui.tools.api.control.SiriusUncontrolHandler;
import org.eclipse.sirius.ui.tools.internal.actions.control.ControlAction;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DesignerControlAction
extends ControlAction {
    @Override
    public void run() {
        final boolean controlling = this.command == null;
        int choice = 0;
        final Session session = SessionManager.INSTANCE.getSession(this.eObject);
        if (session != null) {
            if (session.getStatus() == SessionStatus.DIRTY) {
                choice = SWTUtil.showSaveDialog((Object)session, (String)Messages.DesignerControlAction_saveDialogTitle, (boolean)true);
            }
            if (choice == 0) {
                try {
                    new ProgressMonitorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell()).run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                            try {
                                monitor.beginTask(controlling ? Messages.DesignerControlAction_controlTask : Messages.DesignerControlAction_uncontrolTask, 2);
                                if (session.isOpen()) {
                                    monitor.subTask(Messages.DesignerControlAction_savingTask);
                                    session.save((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                }
                                Shell activeShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                                if (controlling) {
                                    new SiriusControlHandler().performControl(activeShell, DesignerControlAction.this.eObject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                } else {
                                    new SiriusUncontrolHandler().performUncontrol(activeShell, DesignerControlAction.this.eObject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e));
                }
                catch (InterruptedException e) {
                    SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e));
                }
            }
        }
        this.updateSelection(this.getStructuredSelection());
    }

    @Override
    public boolean updateSelection(IStructuredSelection selection) {
        this.eObject = null;
        this.selection = null;
        this.setEditingDomain(null);
        Iterator it = selection.iterator();
        while (it.hasNext() && this.getEditingDomain() == null) {
            Object next = it.next();
            if (!(next instanceof EObject)) continue;
            this.eObject = (EObject)next;
            this.setEditingDomain((EditingDomain)TransactionUtil.getEditingDomain((EObject)this.eObject));
            break;
        }
        return this.getEditingDomain() != null && super.updateSelection(selection);
    }

    public boolean isEnabled() {
        return super.isEnabled() && SessionManager.INSTANCE.getSession(this.eObject) != null;
    }
}

