/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.selection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.sirius.viewpoint.description.TypedVariable;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TypedVariableValueDialog
extends Dialog {
    public static final String ICON_INFORMATION = "icons/full/others/prefshelp.gif";
    private List<Text> valueTextList;
    private List<TypedVariable> typedVariableList;
    private List<String> values = new ArrayList<String>();
    private List<String> defaultValues;

    public TypedVariableValueDialog(List<TypedVariable> typedVariableList, List<String> defaultValues, Shell parentShell) {
        super(parentShell);
        this.typedVariableList = typedVariableList;
        this.valueTextList = new ArrayList<Text>();
        this.defaultValues = defaultValues;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TypedVariableValueDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Image image = SiriusEditPlugin.getPlugin().getImage(SiriusEditPlugin.Implementation.findImageDescriptor(ICON_INFORMATION));
        int i = 0;
        while (i < this.typedVariableList.size()) {
            GridLayout layout = new GridLayout(3, false);
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            TypedVariable typedVariable = this.typedVariableList.get(i);
            Label label = new Label(composite, 0);
            GridData layoutData = new GridData(1, 1, false, false, 1, 1);
            label.setLayoutData((Object)layoutData);
            label.setText(typedVariable.getName());
            Label labelImage = new Label(composite, 0);
            labelImage.setLayoutData((Object)new GridData(1, 1, false, false));
            if (image != null) {
                labelImage.setImage(image);
            }
            labelImage.setToolTipText(typedVariable.getUserDocumentation());
            Text text = new Text(composite, 2048);
            this.valueTextList.add(text);
            layoutData = new GridData(4, 1, true, false);
            text.setLayoutData((Object)layoutData);
            text.setText(this.defaultValues.get(i));
            ++i;
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        for (Text text : this.valueTextList) {
            this.values.add(text.getText());
        }
        super.okPressed();
    }

    public List<String> getValues() {
        return this.values;
    }
}

