/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.export;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.dialect.ExportFormat;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExportToCsvHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DRepresentation currentRepresentation;
        IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editorPart instanceof DialectEditor && (currentRepresentation = ((DialectEditor)editorPart).getRepresentation()) instanceof DTable) {
            DTable table = (DTable)currentRepresentation;
            Shell shell = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell();
            FileDialog fileDialog = new FileDialog(shell, 8192);
            fileDialog.setFileName(table.getName() + ".csv");
            fileDialog.setFilterExtensions(new String[]{"*.csv"});
            fileDialog.setFilterNames(new String[]{"Comma Separated Values"});
            String fileName = fileDialog.open();
            if (fileName != null) {
                try {
                    DialectUIManager.INSTANCE.export((DRepresentation)table, null, Path.fromOSString((String)fileName), new ExportFormat(ExportFormat.ExportDocumentFormat.CSV, null), (IProgressMonitor)new NullProgressMonitor(), false);
                }
                catch (CoreException exception) {
                    SiriusPlugin.getDefault().error(exception.getMessage(), (Throwable)exception);
                }
            }
        }
        return null;
    }
}

