/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.description;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LayoutDirection implements Enumerator
{
    TOP_TO_BOTTOM(0, "TopToBottom", "topToBottom"),
    LEFT_TO_RIGHT(1, "LeftToRight", "LeftToRight"),
    BOTTOM_TO_TOP(2, "BottomToTop", "bottomToTop");

    public static final int TOP_TO_BOTTOM_VALUE = 0;
    public static final int LEFT_TO_RIGHT_VALUE = 1;
    public static final int BOTTOM_TO_TOP_VALUE = 2;
    private static final LayoutDirection[] VALUES_ARRAY;
    public static final List<LayoutDirection> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LayoutDirection[]{TOP_TO_BOTTOM, LEFT_TO_RIGHT, BOTTOM_TO_TOP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LayoutDirection get(String literal) {
        LayoutDirection[] layoutDirectionArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            LayoutDirection result = layoutDirectionArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static LayoutDirection getByName(String name) {
        LayoutDirection[] layoutDirectionArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            LayoutDirection result = layoutDirectionArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static LayoutDirection get(int value) {
        switch (value) {
            case 0: {
                return TOP_TO_BOTTOM;
            }
            case 1: {
                return LEFT_TO_RIGHT;
            }
            case 2: {
                return BOTTOM_TO_TOP;
            }
        }
        return null;
    }

    private LayoutDirection(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

