/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.meta.metaData;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MdGraphFeature implements Enumerator
{
    SELF_LOOPS(0, "self_loops", "self_loops"),
    INSIDE_SELF_LOOPS(1, "inside_self_loops", "inside_self_loops"),
    MULTI_EDGES(2, "multi_edges", "multi_edges"),
    EDGE_LABELS(3, "edge_labels", "edge_labels"),
    PORTS(4, "ports", "ports"),
    COMPOUND(5, "compound", "compound"),
    CLUSTERS(6, "clusters", "clusters"),
    DISCONNECTED(7, "disconnected", "disconnected");

    public static final int SELF_LOOPS_VALUE = 0;
    public static final int INSIDE_SELF_LOOPS_VALUE = 1;
    public static final int MULTI_EDGES_VALUE = 2;
    public static final int EDGE_LABELS_VALUE = 3;
    public static final int PORTS_VALUE = 4;
    public static final int COMPOUND_VALUE = 5;
    public static final int CLUSTERS_VALUE = 6;
    public static final int DISCONNECTED_VALUE = 7;
    private static final MdGraphFeature[] VALUES_ARRAY;
    public static final List<MdGraphFeature> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MdGraphFeature[]{SELF_LOOPS, INSIDE_SELF_LOOPS, MULTI_EDGES, EDGE_LABELS, PORTS, COMPOUND, CLUSTERS, DISCONNECTED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MdGraphFeature get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MdGraphFeature result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MdGraphFeature getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MdGraphFeature result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MdGraphFeature get(int value) {
        switch (value) {
            case 0: {
                return SELF_LOOPS;
            }
            case 1: {
                return INSIDE_SELF_LOOPS;
            }
            case 2: {
                return MULTI_EDGES;
            }
            case 3: {
                return EDGE_LABELS;
            }
            case 4: {
                return PORTS;
            }
            case 5: {
                return COMPOUND;
            }
            case 6: {
                return CLUSTERS;
            }
            case 7: {
                return DISCONNECTED;
            }
        }
        return null;
    }

    private MdGraphFeature(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

