/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.business;

import org.eclipse.sirius.tests.swtbot.support.api.bot.SWTDesignerBot;
import org.eclipse.sirius.tests.swtbot.support.api.business.sessionbrowser.AbstractUIElementWithTreeItem;
import org.eclipse.sirius.tests.swtbot.support.utils.SWTBotCommonHelper;
import org.eclipse.sirius.tests.swtbot.support.utils.SWTBotUtils;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;

public abstract class AbstractUIRepresentation<E extends SWTBotEditor>
extends AbstractUIElementWithTreeItem {
    protected SWTDesignerBot designerBot = new SWTDesignerBot();
    private final String representationName;

    public AbstractUIRepresentation(SWTBotTreeItem treeItem, String representationName) {
        super(treeItem);
        this.representationName = representationName;
    }

    public void close() {
        SWTBotCommonHelper.closeCurrentEditor();
    }

    protected void doOpen() {
        if (this.getTreeItem() != null) {
            this.getTreeItem().select().setFocus();
            this.getTreeItem().doubleClick();
        }
        SWTBotUtils.waitProgressMonitorClose("Open representation");
    }

    protected void doSave() {
        SWTBotCommonHelper.saveCurrentEditor();
    }

    public void delete() {
        SWTBotUtils.clickContextMenu(this.getTreeItem(), "Delete");
    }

    protected String getRepresentationName() {
        return this.representationName;
    }

    public DRepresentation getDRepresentation() {
        DRepresentation dRepresentation = null;
        IEditorPart editorPart = ((IEditorReference)this.getEditor().getReference()).getEditor(false);
        if (editorPart instanceof DialectEditor) {
            DialectEditor dialectEditor = (DialectEditor)editorPart;
            dRepresentation = dialectEditor.getRepresentation();
        }
        return dRepresentation;
    }

    public abstract E getEditor();
}

