/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.condition;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;

public final class BendpointMovedCondition
extends DefaultCondition {
    private final ConnectionEditPart connectionEditPart;
    private final Point initialLocation;
    private boolean checkFirstBendpoint;
    private boolean checkLastBendpoint;
    private int bendpointPosition;

    public BendpointMovedCondition(ConnectionEditPart connectionEditPart, Point initialLocation) {
        this.connectionEditPart = connectionEditPart;
        this.initialLocation = initialLocation;
    }

    public BendpointMovedCondition checkFirstBendpoint() {
        this.checkFirstBendpoint = true;
        this.checkLastBendpoint = false;
        this.bendpointPosition = -1;
        return this;
    }

    public BendpointMovedCondition checkLastBendpoint() {
        this.checkFirstBendpoint = false;
        this.checkLastBendpoint = true;
        this.bendpointPosition = -1;
        return this;
    }

    public BendpointMovedCondition checkBendpointAtPosition(int bendpointPos) {
        this.checkFirstBendpoint = false;
        this.checkLastBendpoint = false;
        this.bendpointPosition = bendpointPos;
        return this;
    }

    public boolean test() throws Exception {
        boolean location = false;
        PointList points = ((PolylineConnectionEx)this.connectionEditPart.getFigure()).getPoints();
        if (this.checkFirstBendpoint) {
            location = !this.initialLocation.equals((Object)points.getFirstPoint());
        } else if (this.checkLastBendpoint) {
            location = !this.initialLocation.equals((Object)points.getLastPoint());
        } else if (this.bendpointPosition >= 0 || this.bendpointPosition < points.size()) {
            location = !this.initialLocation.equals((Object)points.getPoint(this.bendpointPosition));
        }
        return location;
    }

    public String getFailureMessage() {
        return "The bendpoint at location " + String.valueOf(this.initialLocation) + " has not been moved";
    }
}

