/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.widget;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.ContextMenuFinder;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.results.ListResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;

public class SWTBotShellForTabbar
extends SWTBotShell {
    public SWTBotShellForTabbar(Shell shell) throws WidgetNotFoundException {
        super(shell);
    }

    protected SWTBotMenu contextMenu(Control control, final String text) throws WidgetNotFoundException {
        Matcher withMnemonic = WidgetMatcherFactory.withMnemonic((String)text);
        final Matcher matcher = Matchers.allOf((Matcher)WidgetMatcherFactory.widgetOfType(MenuItem.class), (Matcher)withMnemonic);
        final ContextMenuFinder menuFinder = new ContextMenuFinder(control){

            public List<MenuItem> findMenus(final Matcher<MenuItem> matcher) {
                return (List)UIThreadRunnable.syncExec((Display)this.display, (Result)new ListResult<MenuItem>(){

                    public List<MenuItem> run() {
                        Menu[] menus = SWTBotShellForTabbar.this.getMenus((Shell)(this).SWTBotShellForTabbar.this.widget);
                        int i = menus.length - 1;
                        while (i >= 0) {
                            if (menus[i] != null) {
                                MenuItem[] menuItemArray = menus[i].getItems();
                                int n = menuItemArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    MenuItem item = menuItemArray[n2];
                                    if (matcher.matches((Object)item)) {
                                        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
                                        menuItems.add(item);
                                        return menuItems;
                                    }
                                    ++n2;
                                }
                            }
                            --i;
                        }
                        return Collections.emptyList();
                    }
                });
            }
        };
        new SWTBot().waitUntil((ICondition)new DefaultCondition(){

            public String getFailureMessage() {
                return "Could not find context menu with text: " + text;
            }

            public boolean test() throws Exception {
                return !menuFinder.findMenus(matcher).isEmpty();
            }
        });
        return new SWTBotMenu((MenuItem)menuFinder.findMenus(matcher).get(0), (SelfDescribing)matcher);
    }

    private Menu[] getMenus(Shell shell) {
        try {
            Field field = Decorations.class.getDeclaredField("menus");
            field.setAccessible(true);
            return (Menu[])field.get(shell);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        return null;
    }
}

