/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.manipulation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class ChangeCorrectionProposalCore
implements IAdaptable {
    protected Change fChange;
    protected String fName;
    protected int fRelevance;
    private String fCommandId;

    public ChangeCorrectionProposalCore(String name, Change change, int relevance) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        this.fName = name;
        this.fChange = change;
        this.fRelevance = relevance;
    }

    public void apply() throws CoreException {
        this.performChange();
    }

    protected void performChange() throws CoreException {
        block9: {
            Change change = null;
            try {
                Change undoChange;
                change = this.getChange();
                if (change == null) break block9;
                change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                RefactoringStatus valid = change.isValid((IProgressMonitor)new NullProgressMonitor());
                if (valid.hasFatalError()) {
                    Status status = new Status(4, JavaManipulation.getPreferenceNodeId(), 4, valid.getMessageMatchingSeverity(4), null);
                    throw new CoreException((IStatus)status);
                }
                IUndoManager manager = RefactoringCore.getUndoManager();
                boolean successful = false;
                try {
                    manager.aboutToPerformChange(change);
                    undoChange = change.perform((IProgressMonitor)new NullProgressMonitor());
                    successful = true;
                }
                finally {
                    manager.changePerformed(change, successful);
                }
                if (undoChange != null) {
                    undoChange.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                    manager.addUndo(this.getName(), undoChange);
                }
            }
            finally {
                if (change != null) {
                    change.dispose();
                }
                change = null;
            }
        }
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        StringBuilder buf;
        block3: {
            String name;
            block4: {
                buf = new StringBuilder();
                buf.append("<p>");
                Change change = this.getChange();
                if (change == null) break block3;
                name = change.getName();
                if (name.length() != 0) break block4;
                return null;
            }
            try {
                buf.append(name);
            }
            catch (CoreException e) {
                buf.append("Unexpected error when accessing this proposal:<p><pre>");
                buf.append(e.getLocalizedMessage());
                buf.append("</pre>");
            }
        }
        return null;
        buf.append("</p>");
        return buf.toString();
    }

    public String getName() {
        return this.fName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change getChange() throws CoreException {
        ChangeCorrectionProposalCore changeCorrectionProposalCore = this;
        synchronized (changeCorrectionProposalCore) {
            if (this.fChange == null) {
                this.fChange = this.createChange();
            }
        }
        return this.fChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change getCurrentChange() {
        ChangeCorrectionProposalCore changeCorrectionProposalCore = this;
        synchronized (changeCorrectionProposalCore) {
            return this.fChange;
        }
    }

    protected Change createChange() throws CoreException {
        return new NullChange();
    }

    public void setDisplayName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        this.fName = name;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }

    public String getCommandId() {
        return this.fCommandId;
    }

    public void setCommandId(String commandId) {
        this.fCommandId = commandId;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isInstance(this)) {
            return (T)this;
        }
        return null;
    }
}

