/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.core.internal;

import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.cmake.core.ICMakeToolChainFile;
import org.eclipse.cdt.cmake.core.internal.Activator;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.core.runtime.CoreException;

public class CMakeToolChainFile
implements ICMakeToolChainFile {
    String n;
    private final Path path;
    private IToolChain toolchain;
    final Map<String, String> properties = new HashMap<String, String>();

    public CMakeToolChainFile(String n, Path path) {
        this.n = n;
        this.path = path;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public String getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    public IToolChain getToolChain() throws CoreException {
        if (this.toolchain == null) {
            Collection tcs;
            IToolChainManager tcManager = Activator.getService(IToolChainManager.class);
            this.toolchain = tcManager.getToolChain(this.properties.get("cdt.toolChain.type"), this.properties.get("cdt.toolChain.id"));
            if (this.toolchain == null && !(tcs = tcManager.getToolChainsMatching(this.properties)).isEmpty()) {
                this.toolchain = (IToolChain)tcs.iterator().next();
            }
        }
        return this.toolchain;
    }

    boolean matches(Map<String, String> properties) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            if (property.getValue().equals(this.getProperty(property.getKey()))) continue;
            return false;
        }
        return true;
    }
}

