/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.dataprovider;

import org.eclipse.cdt.core.cdtvariables.ICdtVariablesContributor;
import org.eclipse.cdt.core.settings.model.CConfigurationStatus;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CFileData;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.core.settings.model.extension.CTargetPlatformData;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildFileData;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildFolderData;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildLanguageData;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildVariablesContributor;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.DataProviderMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;

public class BuildConfigurationData
extends CConfigurationData {
    private Configuration fCfg;

    public BuildConfigurationData(IConfiguration cfg) {
        this.fCfg = (Configuration)cfg;
    }

    public IConfiguration getConfiguration() {
        return this.fCfg;
    }

    public CFileData createFileData(IPath path, CFileData base) throws CoreException {
        String id = ManagedBuildManager.calculateChildId(this.fCfg.getId(), null);
        IFileInfo info = this.fCfg.createFileInfo(path, ((BuildFileData)base).getFileInfo(), id, path.lastSegment());
        return info.getFileData();
    }

    public CFileData createFileData(IPath path, CFolderData base, CLanguageData baseLangData) throws CoreException {
        String id = ManagedBuildManager.calculateChildId(this.fCfg.getId(), null);
        ITool baseTool = baseLangData instanceof BuildLanguageData ? ((BuildLanguageData)baseLangData).getTool() : null;
        IFileInfo info = this.fCfg.createFileInfo(path, ((BuildFolderData)base).getFolderInfo(), baseTool, id, path.lastSegment());
        return info.getFileData();
    }

    public CFolderData createFolderData(IPath path, CFolderData base) throws CoreException {
        String id = ManagedBuildManager.calculateChildId(this.fCfg.getId(), null);
        IFolderInfo folderInfo = this.fCfg.createFolderInfo(path, ((BuildFolderData)base).getFolderInfo(), id, base.getName());
        return folderInfo.getFolderData();
    }

    public String getDescription() {
        return this.fCfg.getDescription();
    }

    public CResourceData[] getResourceDatas() {
        IResourceInfo[] infos = this.fCfg.getResourceInfos();
        CResourceData[] datas = new CResourceData[infos.length];
        int i = 0;
        while (i < infos.length) {
            datas[i] = infos[i].getResourceData();
            ++i;
        }
        return datas;
    }

    public CFolderData getRootFolderData() {
        return this.fCfg.getRootFolderInfo().getFolderData();
    }

    public void removeResourceData(CResourceData data) throws CoreException {
        this.fCfg.removeResourceInfo(data.getPath());
    }

    public void setDescription(String description) {
        this.fCfg.setDescription(description);
    }

    public String getId() {
        return this.fCfg.getId();
    }

    public String getName() {
        return this.fCfg.getName();
    }

    public void setName(String name) {
        this.fCfg.setName(name);
    }

    public boolean isValid() {
        return this.fCfg != null;
    }

    public CTargetPlatformData getTargetPlatformData() {
        return this.fCfg.getToolChain().getTargetPlatformData();
    }

    public ICSourceEntry[] getSourceEntries() {
        return this.fCfg.getSourceEntries();
    }

    public void setSourceEntries(ICSourceEntry[] entries) {
        this.fCfg.setSourceEntries(entries);
    }

    public CBuildData getBuildData() {
        return this.fCfg.getBuildData();
    }

    public ICdtVariablesContributor getBuildVariablesContributor() {
        return new BuildVariablesContributor(this);
    }

    void clearCachedData() {
        this.fCfg.clearCachedData();
        CResourceData[] datas = this.getResourceDatas();
        int i = 0;
        while (i < datas.length) {
            CResourceData data = datas[i];
            if (data.getType() == 4) {
                ((BuildFolderData)data).clearCachedData();
            } else {
                ((BuildFileData)data).clearCachedData();
            }
            ++i;
        }
    }

    public CConfigurationStatus getStatus() {
        int flags = 0;
        String msg = null;
        if (!this.fCfg.isSupported()) {
            flags |= 4;
            IToolChain toolChain = this.fCfg.getToolChain();
            String tname = toolChain != null ? toolChain.getName() : "";
            msg = NLS.bind((String)DataProviderMessages.getString("BuildConfigurationData.NoToolchainSupport"), (Object)tname);
        } else if (ManagedBuildManager.getExtensionConfiguration(this.fCfg) == null) {
            flags |= 8;
            msg = NLS.bind((String)DataProviderMessages.getString("BuildConfigurationData.OrphanedConfiguration"), (Object)this.fCfg.getId());
        }
        if (flags != 0) {
            return new CConfigurationStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), flags, msg, null);
        }
        return CConfigurationStatus.CFG_STATUS_OK;
    }
}

