/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.autotools.ui.editors.parser;

import org.eclipse.cdt.autotools.ui.editors.parser.ITokenConstants;
import org.eclipse.jface.text.IDocument;

public class Token
implements ITokenConstants {
    final int type;
    final String text;
    final int offset;
    final int length;
    final IDocument document;

    public Token(int type, String text, IDocument document, int offset, int length) {
        this.type = type;
        this.text = text;
        this.document = document;
        this.offset = offset;
        this.length = length;
    }

    public String toString() {
        return this.text;
    }

    public int getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public IDocument getDocument() {
        return this.document;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public boolean followsSpace() {
        char[] text = this.document.get().toCharArray();
        if (this.offset == 0) {
            return false;
        }
        return " \t\r\n\f".indexOf(text[this.offset - 1]) >= 0;
    }
}

