/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.launchview.internal.view;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.ui.launchview.internal.LaunchViewMessages;
import org.eclipse.debug.ui.launchview.internal.view.LaunchViewImpl;
import org.eclipse.debug.ui.launchview.services.ILaunchObject;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;

public class LaunchAction {
    private static final Map<String, String> COMMON_MODE_ICONS = new TreeMap<String, String>();
    private final ILaunchMode mode;
    private final LaunchViewImpl view;

    static {
        COMMON_MODE_ICONS.put("run", "icons/run_exc.svg");
        COMMON_MODE_ICONS.put("debug", "icons/debug_exc.svg");
        COMMON_MODE_ICONS.put("profile", "icons/profile_exc.svg");
        COMMON_MODE_ICONS.put("coverage", "icons/coverage.svg");
    }

    public LaunchAction(ILaunchMode mode, LaunchViewImpl view) {
        this.mode = mode;
        this.view = view;
    }

    public MMenuItem asMMenuItem() {
        MDirectMenuItem item = MMenuFactory.INSTANCE.createDirectMenuItem();
        item.setLabel(this.mode.getLabel());
        item.setObject((Object)this);
        if (COMMON_MODE_ICONS.containsKey(this.mode.getIdentifier())) {
            item.setIconURI("platform:/plugin/org.eclipse.debug.ui.launchview/" + COMMON_MODE_ICONS.get(this.mode.getIdentifier()));
        }
        return item;
    }

    @CanExecute
    public boolean isEnabled() {
        Object elements = this.view.get();
        return !elements.isEmpty() && elements.stream().allMatch(m -> {
            try {
                return m.getType().getDelegates(Collections.singleton(this.mode.getIdentifier())).length > 0;
            }
            catch (CoreException e) {
                ILog.of(this.getClass()).warn(LaunchViewMessages.LaunchAction_FailedFetchLaunchDelegates, (Throwable)e);
                return false;
            }
        });
    }

    @Execute
    public void run() {
        Object objects = this.view.get();
        Iterator iterator = objects.iterator();
        while (iterator.hasNext()) {
            ILaunchObject m = (ILaunchObject)iterator.next();
            m.launch(this.mode);
            if (objects.size() <= 1) continue;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

