/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number.parse;

import com.ibm.icu.impl.StaticUnicodeSets;
import com.ibm.icu.impl.StringSegment;
import com.ibm.icu.impl.number.parse.ParsedNumber;
import com.ibm.icu.impl.number.parse.SymbolMatcher;
import com.ibm.icu.text.DecimalFormatSymbols;

public class ApproximatelySignMatcher
extends SymbolMatcher {
    private static final ApproximatelySignMatcher DEFAULT = new ApproximatelySignMatcher(false);
    private static final ApproximatelySignMatcher DEFAULT_ALLOW_TRAILING = new ApproximatelySignMatcher(true);
    private final boolean allowTrailing;

    public static ApproximatelySignMatcher getInstance(DecimalFormatSymbols symbols, boolean allowTrailing) {
        String symbolString = symbols.getApproximatelySignString();
        if (ApproximatelySignMatcher.DEFAULT.uniSet.contains(symbolString)) {
            return allowTrailing ? DEFAULT_ALLOW_TRAILING : DEFAULT;
        }
        return new ApproximatelySignMatcher(symbolString, allowTrailing);
    }

    private ApproximatelySignMatcher(String symbolString, boolean allowTrailing) {
        super(symbolString, ApproximatelySignMatcher.DEFAULT.uniSet);
        this.allowTrailing = allowTrailing;
    }

    private ApproximatelySignMatcher(boolean allowTrailing) {
        super(StaticUnicodeSets.Key.APPROXIMATELY_SIGN);
        this.allowTrailing = allowTrailing;
    }

    @Override
    protected boolean isDisabled(ParsedNumber result) {
        return !this.allowTrailing && result.seenNumber();
    }

    @Override
    protected void accept(StringSegment segment, ParsedNumber result) {
        result.setCharsConsumed(segment);
    }

    public String toString() {
        return "<ApproximatelySignMatcher>";
    }
}

