/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.locks.Lock;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.ResourceLock;

class CompositeLock
implements ResourceLock {
    private final List<ExclusiveResource> resources;
    private final List<Lock> locks;
    private final boolean exclusive;

    CompositeLock(List<ExclusiveResource> resources, List<Lock> locks) {
        Preconditions.condition((resources.size() == locks.size() ? 1 : 0) != 0, (String)"Resources and locks must have the same size");
        this.resources = List.copyOf(resources);
        this.locks = (List)Preconditions.notEmpty(locks, (String)"Locks must not be empty");
        this.exclusive = resources.stream().anyMatch(resource -> resource.getLockMode() == ExclusiveResource.LockMode.READ_WRITE);
    }

    @Override
    public List<ExclusiveResource> getResources() {
        return this.resources;
    }

    List<Lock> getLocks() {
        return this.locks;
    }

    @Override
    public ResourceLock acquire() throws InterruptedException {
        ForkJoinPool.managedBlock(new CompositeLockManagedBlocker());
        return this;
    }

    private void acquireAllLocks() throws InterruptedException {
        ArrayList<Lock> acquiredLocks = new ArrayList<Lock>(this.locks.size());
        try {
            for (Lock lock : this.locks) {
                lock.lockInterruptibly();
                acquiredLocks.add(lock);
            }
        }
        catch (InterruptedException e) {
            this.release(acquiredLocks);
            throw e;
        }
    }

    @Override
    public void release() {
        this.release(this.locks);
    }

    private void release(List<Lock> acquiredLocks) {
        for (int i = acquiredLocks.size() - 1; i >= 0; --i) {
            acquiredLocks.get(i).unlock();
        }
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("resources", this.resources).toString();
    }

    private class CompositeLockManagedBlocker
    implements ForkJoinPool.ManagedBlocker {
        private volatile boolean acquired;

        private CompositeLockManagedBlocker() {
        }

        @Override
        public boolean block() throws InterruptedException {
            if (!this.acquired) {
                CompositeLock.this.acquireAllLocks();
                this.acquired = true;
            }
            return true;
        }

        @Override
        public boolean isReleasable() {
            return this.acquired;
        }
    }
}

