/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.server.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ptp.internal.remote.server.core.Activator;
import org.eclipse.ptp.remote.server.core.AbstractRemoteServerRunner;
import org.eclipse.remote.core.IRemoteConnection;

public class RemoteServerManager {
    private static final String REMOTE_SERVER_EXTENSION_POINT_ID = "remoteServer";
    private static final String REMOTE_SERVER_EXTENSION_ID = "remoteServer";
    private static final String REMOTE_SERVER_OVERRIDE_EXTENSION_ID = "remoteServerOverride";
    private static final Map<String, AbstractRemoteServerRunner> fServerMap = new HashMap<String, AbstractRemoteServerRunner>();
    private static final String ATTR_ID = "id";
    private static final String ATTR_LAUNCH_COMMAND = "launchCommand";
    private static final String ATTR_UNPACK_COMMAND = "unpackCommand";
    private static final String ATTR_PAYLOAD = "payload";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_CONTINUOUS = "continuous";
    private static final String ATTR_VERIFY_LAUNCH_COMMAND = "verifyLaunchCommand";
    private static final String ATTR_VERIFY_LAUNCH_PATTERN = "verifyLaunchPattern";
    private static final String ATTR_VERIFY_LAUNCH_FAILMESSAGE = "verifyLaunchFailMessage";
    private static final String ATTR_VERIFY_UNPACK_COMMAND = "verifyUnpackCommand";
    private static final String ATTR_VERIFY_UNPACK_PATTERN = "verifyUnpackPattern";
    private static final String ATTR_VERIFY_UNPACK_FAILMESSAGE = "verifyUnpackFailMessage";

    private static AbstractRemoteServerRunner createServer(String id) {
        AbstractRemoteServerRunner server = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.ptp.remote.server.core", "remoteServer");
        if (extensionPoint != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = ext.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    if (ce.getName().equals("remoteServer") && id.equals(ce.getAttribute(ATTR_ID))) {
                        try {
                            Object exec = ce.createExecutableExtension(ATTR_CLASS);
                            if (exec instanceof AbstractRemoteServerRunner) {
                                server = (AbstractRemoteServerRunner)((Object)exec);
                                server.setBundleId(ce.getContributor().getName());
                                server.setLaunchCommand(ce.getAttribute(ATTR_LAUNCH_COMMAND));
                                server.setUnpackCommand(ce.getAttribute(ATTR_UNPACK_COMMAND));
                                server.setPayload(ce.getAttribute(ATTR_PAYLOAD));
                                server.setContinuous(Boolean.parseBoolean(ce.getAttribute(ATTR_CONTINUOUS)));
                                server.setVerifyLaunchCommand(ce.getAttribute(ATTR_VERIFY_LAUNCH_COMMAND));
                                server.setVerifyLaunchPattern(ce.getAttribute(ATTR_VERIFY_LAUNCH_PATTERN));
                                server.setVerifyLaunchFailMessage(ce.getAttribute(ATTR_VERIFY_LAUNCH_FAILMESSAGE));
                                server.setVerifyUnpackCommand(ce.getAttribute(ATTR_VERIFY_UNPACK_COMMAND));
                                server.setVerifyUnpackPattern(ce.getAttribute(ATTR_VERIFY_UNPACK_PATTERN));
                                server.setVerifyUnpackFailMessage(ce.getAttribute(ATTR_VERIFY_UNPACK_FAILMESSAGE));
                                RemoteServerManager.checkForOverrides(id, server);
                                return server;
                            }
                        }
                        catch (CoreException e) {
                            Activator.log(e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    private static void checkForOverrides(String id, AbstractRemoteServerRunner server) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.ptp.remote.server.core", "remoteServer");
        if (extensionPoint != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = ext.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    if (ce.getName().equals(REMOTE_SERVER_OVERRIDE_EXTENSION_ID) && id.equals(ce.getAttribute(ATTR_ID))) {
                        String attr = ce.getAttribute(ATTR_LAUNCH_COMMAND);
                        if (attr != null) {
                            server.setLaunchCommand(attr);
                        }
                        if ((attr = ce.getAttribute(ATTR_UNPACK_COMMAND)) != null) {
                            server.setUnpackCommand(attr);
                        }
                        if ((attr = ce.getAttribute(ATTR_PAYLOAD)) != null) {
                            server.setPayload(attr);
                        }
                        if ((attr = ce.getAttribute(ATTR_VERIFY_LAUNCH_COMMAND)) != null) {
                            server.setVerifyLaunchCommand(attr);
                        }
                        if ((attr = ce.getAttribute(ATTR_VERIFY_LAUNCH_PATTERN)) != null) {
                            server.setVerifyLaunchPattern(attr);
                        }
                        if ((attr = ce.getAttribute(ATTR_VERIFY_LAUNCH_FAILMESSAGE)) != null) {
                            server.setVerifyLaunchFailMessage(attr);
                        }
                        if ((attr = ce.getAttribute(ATTR_VERIFY_UNPACK_COMMAND)) != null) {
                            server.setVerifyUnpackCommand(attr);
                        }
                        if ((attr = ce.getAttribute(ATTR_VERIFY_UNPACK_PATTERN)) != null) {
                            server.setVerifyUnpackPattern(attr);
                        }
                        if ((attr = ce.getAttribute(ATTR_VERIFY_UNPACK_FAILMESSAGE)) != null) {
                            server.setVerifyUnpackFailMessage(attr);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private static String getKey(String id, IRemoteConnection connection) {
        return String.valueOf(id) + ";" + connection.getConnectionType().getId() + "." + connection.getName();
    }

    public static AbstractRemoteServerRunner getServer(String id, IRemoteConnection connection) {
        AbstractRemoteServerRunner server = fServerMap.get(RemoteServerManager.getKey(id, connection));
        if (server == null && (server = RemoteServerManager.createServer(id)) != null) {
            server.setRemoteConnection(connection);
            fServerMap.put(RemoteServerManager.getKey(id, connection), server);
        }
        return server;
    }
}

