/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.List;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.AttributeGroup;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.IAttributed;
import org.eclipse.php.core.ast.nodes.Statement;

public abstract class AttributedStatement
extends Statement
implements IAttributed {
    private ASTNode.NodeList<AttributeGroup> attributes = new ASTNode.NodeList(this.getAttributesProperty());

    public AttributedStatement(AST ast) {
        super(ast);
    }

    public AttributedStatement(int start, int end, AST ast) {
        super(start, end, ast);
    }

    protected abstract ChildListPropertyDescriptor getAttributesProperty();

    @Override
    public List<AttributeGroup> attributes() {
        return this.attributes;
    }

    @Override
    List<? extends ASTNode> internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == this.getAttributesProperty()) {
            return this.attributes();
        }
        return super.internalGetChildListProperty(property);
    }

    protected void toStringAttributes(StringBuilder buffer, String tab) {
        if (this.attributes().size() > 0) {
            buffer.append(tab).append("<Attributes>\n");
            for (AttributeGroup g : this.attributes()) {
                g.toString(buffer, "\t" + tab);
                buffer.append("\n");
            }
            buffer.append(tab).append("</Attributes>\n");
        }
    }
}

