/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.AttributeGroup;
import org.eclipse.php.core.ast.nodes.BodyDeclaration;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.visitor.Visitor;

public class EnumCaseDeclaration
extends BodyDeclaration {
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(EnumCaseDeclaration.class, "name", Identifier.class, true, false);
    public static final ChildPropertyDescriptor INITIALIZER_PROPERTY = new ChildPropertyDescriptor(EnumCaseDeclaration.class, "initializer", Identifier.class, false, false);
    public static final SimplePropertyDescriptor MODIFIER_PROPERTY = new SimplePropertyDescriptor(EnumCaseDeclaration.class, "modifier", Integer.class, false);
    public static final ChildListPropertyDescriptor ATTRIBUTES_PROPERTY = new ChildListPropertyDescriptor(EnumCaseDeclaration.class, "attributes", AttributeGroup.class, true);
    private Identifier name;
    private Expression initializer;
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> properyList = new ArrayList<StructuralPropertyDescriptor>(4);
        properyList.add(NAME_PROPERTY);
        properyList.add(INITIALIZER_PROPERTY);
        properyList.add(MODIFIER_PROPERTY);
        properyList.add(ATTRIBUTES_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    public EnumCaseDeclaration(int start, int end, AST ast, Identifier name, Expression initializer) {
        this(start, end, ast, name, initializer, null);
    }

    public EnumCaseDeclaration(int start, int end, AST ast, Identifier name, Expression initializer, List<AttributeGroup> attributes) {
        super(start, end, ast, 6, false);
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (attributes != null) {
            this.attributes().addAll(attributes);
        }
        this.setName(name);
        this.setInitializer(initializer);
    }

    public EnumCaseDeclaration(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (AttributeGroup attr : this.attributes()) {
            attr.accept(visitor);
        }
        this.name.accept(visitor);
        if (this.initializer != null) {
            this.initializer.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        for (AttributeGroup attr : this.attributes()) {
            attr.traverseTopDown(visitor);
        }
        this.name.traverseTopDown(visitor);
        if (this.initializer != null) {
            this.initializer.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (AttributeGroup attr : this.attributes()) {
            attr.traverseBottomUp(visitor);
        }
        this.name.traverseBottomUp(visitor);
        if (this.initializer != null) {
            this.initializer.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuilder buffer, String tab) {
        buffer.append(tab).append("<EnumCaseDeclaration");
        this.appendInterval(buffer);
        buffer.append(" modifier='").append(this.getModifierString()).append('\'');
        buffer.append(">\n");
        this.toStringAttributes(buffer, tab + "\t");
        buffer.append(tab).append("\t").append("<VariableName>\n");
        this.name.toString(buffer, "\t\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("\t").append("</VariableName>\n");
        if (this.initializer != null) {
            buffer.append(tab).append("\t").append("<InitialValue>\n");
            this.initializer.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
            buffer.append(tab).append("\t").append("</InitialValue>\n");
        }
        buffer.append(tab).append("</EnumCaseDeclaration>");
    }

    @Override
    public int getType() {
        return 90;
    }

    public Identifier getName() {
        return this.name;
    }

    public void setName(Identifier id) {
        Identifier oldChild = this.name;
        this.preReplaceChild(oldChild, id, NAME_PROPERTY);
        this.name = id;
        this.postReplaceChild(oldChild, id, NAME_PROPERTY);
    }

    public Expression getInitializer() {
        return this.initializer;
    }

    public void setInitializer(Expression id) {
        Expression oldChild = this.initializer;
        this.preReplaceChild(oldChild, id, INITIALIZER_PROPERTY);
        this.initializer = id;
        this.postReplaceChild(oldChild, id, INITIALIZER_PROPERTY);
    }

    @Override
    ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((Identifier)child);
            return null;
        }
        if (property == INITIALIZER_PROPERTY) {
            if (get) {
                return this.getInitializer();
            }
            this.setInitializer((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Identifier name = ASTNode.copySubtree(target, this.getName());
        Expression initializer = ASTNode.copySubtree(target, this.getInitializer());
        List<AttributeGroup> attributes = ASTNode.copySubtrees(target, this.attributes());
        return new EnumCaseDeclaration(this.getStart(), this.getEnd(), target, name, initializer, attributes);
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public SimplePropertyDescriptor getModifierProperty() {
        return MODIFIER_PROPERTY;
    }

    @Override
    protected ChildListPropertyDescriptor getAttributesProperty() {
        return ATTRIBUTES_PROPERTY;
    }
}

