/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.filters;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.core.util.preferences.IXMLPreferencesStorable;
import org.eclipse.php.internal.ui.util.SearchPattern;
import org.eclipse.php.profile.core.data.ProfilerClassData;
import org.eclipse.php.profile.core.data.ProfilerFileData;
import org.eclipse.php.profile.core.data.ProfilerFunctionData;
import org.eclipse.php.profile.ui.views.TreeElement;

public class ExecutionStatisticsFilterString
extends ViewerFilter
implements IXMLPreferencesStorable {
    public static final String FILTER_BY_FILE_NAME = "File name";
    public static final String FILTER_BY_CLASS_NAME = "Class name";
    public static final String FILTER_BY_FUNCTION_NAME = "Function name";
    private String fString;
    private String fFilterBy;
    private boolean fIsCaseSensitive;

    public ExecutionStatisticsFilterString() {
    }

    public ExecutionStatisticsFilterString(String string, String filterBy, boolean isCaseSensitive) {
        this.fString = string;
        this.fFilterBy = filterBy;
        this.fIsCaseSensitive = isCaseSensitive;
    }

    public String getString() {
        return this.fString;
    }

    public void setString(String string) {
        this.fString = string;
    }

    public String getFilterBy() {
        return this.fFilterBy;
    }

    public void setFilterBy(String filterBy) {
        this.fFilterBy = filterBy;
    }

    public boolean isCaseSensitive() {
        return this.fIsCaseSensitive;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.fIsCaseSensitive = isCaseSensitive;
    }

    public Map<String, Object> storeToMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("string", this.fString);
        map.put("case-sensitive", new Boolean(this.fIsCaseSensitive));
        map.put("filter-by", this.fFilterBy);
        return map;
    }

    public void restoreFromMap(Map<String, Object> map) {
        this.fString = (String)map.get("string");
        this.fIsCaseSensitive = Boolean.getBoolean((String)map.get("case-sensitive"));
        this.fFilterBy = (String)map.get("filter-by");
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        Object data = ((TreeElement)element).getData();
        if (FILTER_BY_FILE_NAME.equals(this.fFilterBy) && data instanceof ProfilerFileData) {
            return SearchPattern.match((String)this.fString, (String)new File(((ProfilerFileData)data).getName()).getName(), (boolean)this.fIsCaseSensitive, (boolean)false);
        }
        if (FILTER_BY_CLASS_NAME.equals(this.fFilterBy) && data instanceof ProfilerClassData) {
            return SearchPattern.match((String)this.fString, (String)((ProfilerClassData)data).getName(), (boolean)this.fIsCaseSensitive, (boolean)false);
        }
        if (FILTER_BY_FUNCTION_NAME.equals(this.fFilterBy) && data instanceof ProfilerFunctionData) {
            return SearchPattern.match((String)this.fString, (String)((ProfilerFunctionData)data).getFunctionName(), (boolean)this.fIsCaseSensitive, (boolean)false);
        }
        return true;
    }
}

