/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;

public class LimitList<T>
extends ArrayList<T> {
    private static final long serialVersionUID = 1L;
    private transient boolean resultLimitExceeded;
    private final AtomicLong limit;

    public LimitList(AtomicLong limit) {
        this.limit = limit;
    }

    @Override
    public void add(int index, T element) {
        this.checkLimit();
        super.add(index, element);
    }

    @Override
    public boolean add(T e) {
        this.checkLimit();
        return super.add(e);
    }

    private void checkLimit() {
        if (this.limit == null) {
            return;
        }
        long result = this.limit.decrementAndGet();
        if (result < 0L) {
            this.limit.set(0L);
            throw new ResultLimitExceededException();
        }
    }

    protected AtomicLong getLimit() {
        return this.limit;
    }

    public boolean isResultLimitExceeded() {
        return this.resultLimitExceeded;
    }

    void setResultLimitExceeded(boolean resultLimitExceeded) {
        this.resultLimitExceeded = resultLimitExceeded;
    }

    public static class ResultLimitExceededException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

