/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.manipulation.ImportReferencesCollector;
import org.eclipse.jdt.internal.corext.codemanipulation.RedundantNullnessTypeAnnotationsFilter;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class ContextSensitiveImportRewriteContext
extends ImportRewrite.ImportRewriteContext {
    private final CompilationUnit fCompilationUnit;
    private final int fPosition;
    private IBinding[] fDeclarationsInScope;
    private Name[] fImportedNames;
    private final ImportRewrite fImportRewrite;
    private RedundantNullnessTypeAnnotationsFilter fRedundantTypeAnnotationsFilter;

    public ContextSensitiveImportRewriteContext(ASTNode node, ImportRewrite importRewrite) {
        this((CompilationUnit)node.getRoot(), node.getStartPosition(), importRewrite, RedundantNullnessTypeAnnotationsFilter.createIfConfigured(node));
    }

    public ContextSensitiveImportRewriteContext(CompilationUnit compilationUnit, int position, ImportRewrite importRewrite) {
        this(compilationUnit, position, importRewrite, RedundantNullnessTypeAnnotationsFilter.createIfConfigured(new NodeFinder((ASTNode)compilationUnit, position, 0).getCoveringNode()));
    }

    private ContextSensitiveImportRewriteContext(CompilationUnit compilationUnit, int position, ImportRewrite importRewrite, RedundantNullnessTypeAnnotationsFilter redundantNullnessTypeAnnotationsFilter) {
        this.fCompilationUnit = compilationUnit;
        this.fPosition = position;
        this.fImportRewrite = importRewrite;
        this.fDeclarationsInScope = null;
        this.fImportedNames = null;
        this.fRedundantTypeAnnotationsFilter = redundantNullnessTypeAnnotationsFilter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int findInContext(String qualifier, String name, int kind) {
        ITypeBinding decl22;
        IBinding[] iBindingArray = this.getDeclarationsInScope();
        int n = iBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding declaration = iBindingArray[n2];
            if (declaration instanceof ITypeBinding) {
                ITypeBinding typeBinding = (ITypeBinding)declaration;
                if (this.isSameType(typeBinding, qualifier, name)) {
                    return 1;
                }
                if (this.isConflicting((IBinding)typeBinding, name)) {
                    return 3;
                }
            } else if (declaration != null && this.isConflicting(declaration, name)) {
                return 3;
            }
            ++n2;
        }
        iBindingArray = this.getImportedNames();
        n = iBindingArray.length;
        n2 = 0;
        while (n2 < n) {
            ITypeBinding typeBinding;
            IBinding importedName = iBindingArray[n2];
            IBinding binding = importedName.resolveBinding();
            if (binding instanceof ITypeBinding && !binding.isRecovered() && this.isConflictingType(typeBinding = (ITypeBinding)binding, qualifier, name)) {
                return 3;
            }
            ++n2;
        }
        List list = this.fCompilationUnit.types();
        for (AbstractTypeDeclaration type : list) {
            ITypeBinding binding = type.resolveBinding();
            if (binding == null) continue;
            if (this.isSameType(binding, qualifier, name)) {
                return 1;
            }
            decl22 = this.containingDeclaration(binding, qualifier, name);
            while (decl22 != null && !decl22.equals((Object)binding)) {
                int modifiers = decl22.getModifiers();
                if (Modifier.isPrivate((int)modifiers)) {
                    return 3;
                }
                decl22 = decl22.getDeclaringClass();
            }
        }
        decl22 = this.fImportRewrite.getAddedModuleImports();
        int binding = ((String[])decl22).length;
        int n3 = 0;
        while (n3 < binding) {
            String moduleName = decl22[n3];
            for (String packageName : this.fImportRewrite.getAddedModuleExportedPackages(moduleName)) {
                if (!qualifier.equals(packageName)) continue;
                return 1;
            }
            ++n3;
        }
        String qualifiedName = JavaModelUtil.concatenateName(qualifier, name);
        String[] stringArray = this.fImportRewrite.getAddedImports();
        int decl22 = stringArray.length;
        binding = 0;
        while (binding < decl22) {
            String addedImport = stringArray[binding];
            if (qualifiedName.equals(addedImport)) {
                return 1;
            }
            if (this.isConflicting(name, addedImport)) {
                return 3;
            }
            ++binding;
        }
        if (!"java.lang".equals(qualifier)) return this.fImportRewrite.getDefaultImportRewriteContext().findInContext(qualifier, name, kind);
        ITypeRoot typeRoot = this.fCompilationUnit.getTypeRoot();
        if (typeRoot == null) return this.fImportRewrite.getDefaultImportRewriteContext().findInContext(qualifier, name, kind);
        IPackageFragment packageFragment = (IPackageFragment)typeRoot.getParent();
        try {
            ICompilationUnit[] iCompilationUnitArray = packageFragment.getCompilationUnits();
            int n4 = iCompilationUnitArray.length;
            int n5 = 0;
            block9: while (true) {
                if (n5 >= n4) {
                    return this.fImportRewrite.getDefaultImportRewriteContext().findInContext(qualifier, name, kind);
                }
                ICompilationUnit cu = iCompilationUnitArray[n5];
                IType[] iTypeArray = cu.getAllTypes();
                int n6 = iTypeArray.length;
                int n7 = 0;
                while (true) {
                    if (n7 >= n6) {
                        ++n5;
                        continue block9;
                    }
                    IType type = iTypeArray[n7];
                    String packageTypeName = type.getFullyQualifiedName();
                    if (this.isConflicting(name, packageTypeName)) {
                        return 3;
                    }
                    ++n7;
                }
                break;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return this.fImportRewrite.getDefaultImportRewriteContext().findInContext(qualifier, name, kind);
    }

    private boolean isConflicting(String name, String importt) {
        int index = importt.lastIndexOf(46);
        String importedName = index == -1 ? importt : importt.substring(index + 1, importt.length());
        return importedName.equals(name);
    }

    private ITypeBinding containingDeclaration(ITypeBinding binding, String qualifier, String name) {
        ITypeBinding[] iTypeBindingArray = binding.getDeclaredTypes();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding childBinding = iTypeBindingArray[n2];
            if (this.isSameType(childBinding, qualifier, name)) {
                return childBinding;
            }
            ITypeBinding result = this.containingDeclaration(childBinding, qualifier, name);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    private boolean isConflicting(IBinding binding, String name) {
        return binding.getName().equals(name);
    }

    private boolean isSameType(ITypeBinding binding, String qualifier, String name) {
        String qualifiedName = JavaModelUtil.concatenateName(qualifier, name);
        return binding.getQualifiedName().equals(qualifiedName);
    }

    private boolean isConflictingType(ITypeBinding binding, String qualifier, String name) {
        return !this.isSameType(binding = binding.getTypeDeclaration(), qualifier, name) && this.isConflicting((IBinding)binding, name);
    }

    private IBinding[] getDeclarationsInScope() {
        if (this.fDeclarationsInScope == null) {
            ScopeAnalyzer analyzer = new ScopeAnalyzer(this.fCompilationUnit);
            this.fDeclarationsInScope = analyzer.getDeclarationsInScope(this.fPosition, 7);
        }
        return this.fDeclarationsInScope;
    }

    private Name[] getImportedNames() {
        if (this.fImportedNames == null) {
            IJavaProject project = null;
            IJavaElement javaElement = this.fCompilationUnit.getJavaElement();
            if (javaElement != null) {
                project = javaElement.getJavaProject();
            }
            ArrayList<SimpleName> imports = new ArrayList<SimpleName>();
            ImportReferencesCollector.collect((ASTNode)this.fCompilationUnit, project, null, imports, null);
            this.fImportedNames = imports.toArray(new Name[imports.size()]);
        }
        return this.fImportedNames;
    }

    public IAnnotationBinding[] removeRedundantTypeAnnotations(IAnnotationBinding[] annotations, ImportRewrite.TypeLocation location, ITypeBinding type) {
        RedundantNullnessTypeAnnotationsFilter redundantTypeAnnotationsFilter = this.fRedundantTypeAnnotationsFilter;
        if (redundantTypeAnnotationsFilter != null) {
            annotations = redundantTypeAnnotationsFilter.removeUnwantedTypeAnnotations(annotations, location, type);
        }
        return super.removeRedundantTypeAnnotations(annotations, location, type);
    }
}

