/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.common.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.archetype.common.util.PathUtils;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.StringUtils;

public class ListScanner {
    public static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.arch-ids", "**/.arch-ids/**", "**/.bzr", "**/.bzr/**", "**/.git", "**/.git/**", "**/.hg", "**/.hg/**", "**/.MySCMServerInfo", "**/.DS_Store"};
    protected String basedir;
    protected boolean everythingIncluded = true;
    protected String[] excludes;
    protected String[] includes;
    protected boolean isCaseSensitive = true;

    public static String getDefaultExcludes() {
        return StringUtils.join((Object[])DEFAULTEXCLUDES, (String)",");
    }

    public static boolean match(String pattern, String str) {
        return ListScanner.match(pattern, str, true);
    }

    protected static boolean match(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.match((String)pattern, (String)str, (boolean)isCaseSensitive);
    }

    protected static boolean matchPath(String pattern, String str) {
        return ListScanner.matchPath(pattern, str, true);
    }

    protected static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPath((String)PathUtils.convertPathForOS(pattern), (String)PathUtils.convertPathForOS(str), (boolean)isCaseSensitive);
    }

    protected static boolean matchPatternStart(String pattern, String str) {
        return ListScanner.matchPatternStart(pattern, str, true);
    }

    protected static boolean matchPatternStart(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPatternStart((String)PathUtils.convertPathForOS(pattern), (String)PathUtils.convertPathForOS(str), (boolean)isCaseSensitive);
    }

    public void addDefaultExcludes() {
        int excludesLength = this.excludes == null ? 0 : this.excludes.length;
        String[] newExcludes = new String[excludesLength + DEFAULTEXCLUDES.length];
        if (excludesLength > 0) {
            System.arraycopy(this.excludes, 0, newExcludes, 0, excludesLength);
        }
        for (int i = 0; i < DEFAULTEXCLUDES.length; ++i) {
            newExcludes[i + excludesLength] = DEFAULTEXCLUDES[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
        }
        this.excludes = newExcludes;
    }

    public String getBasedir() {
        return this.basedir;
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public void setExcludes(List<String> excludesList) {
        String[] excludes = excludesList.toArray(new String[excludesList.size()]);
        if (excludes == null) {
            this.excludes = null;
        } else {
            this.setExcludes(excludes);
        }
    }

    public void setExcludes(String excludes) {
        if (excludes == null) {
            this.excludes = null;
        } else {
            this.setExcludes(StringUtils.split((String)excludes, (String)","));
        }
    }

    public void setIncludes(List<String> includesList) {
        String[] includes = includesList.toArray(new String[includesList.size()]);
        if (includes == null) {
            this.includes = null;
        } else {
            this.setIncludes(includes);
        }
    }

    public void setIncludes(String includes) {
        if (includes == null) {
            this.includes = null;
        } else {
            this.setIncludes(StringUtils.split((String)includes, (String)","));
        }
    }

    public List<String> scan(List<String> files) throws IllegalStateException {
        if (this.basedir == null) {
            throw new IllegalStateException("No basedir set");
        }
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String fileName : files) {
            if (!this.isIncluded(fileName) || this.isExcluded(fileName)) continue;
            result.add(fileName);
        }
        return result;
    }

    protected boolean isExcluded(String name) {
        return this.matchesPatterns(name, this.excludes);
    }

    protected boolean isIncluded(String name) {
        return this.matchesPatterns(name, this.includes);
    }

    protected boolean matchesPatterns(String name, String[] patterns) {
        String path = null;
        String baseDir = this.getBasedir();
        if (baseDir.length() > 0) {
            baseDir = baseDir.concat(File.separator);
        }
        for (int i = 0; i < patterns.length; ++i) {
            path = PathUtils.convertPathForOS(baseDir + patterns[i]);
            if (!ListScanner.matchPath(path, name, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    private void setExcludes(String[] excludes) {
        this.excludes = this.setPatterns(excludes);
    }

    private void setIncludes(String[] includes) {
        this.includes = this.setPatterns(includes);
    }

    private String[] setPatterns(String[] patterns) {
        String[] result = null;
        if (patterns != null && patterns.length > 0) {
            result = new String[patterns.length];
            for (int i = 0; i < patterns.length; ++i) {
                String pattern = patterns[i].trim();
                if (PathUtils.convertPathForOS(pattern).endsWith(File.separator)) {
                    pattern = pattern + "**";
                }
                result[i] = pattern;
            }
        }
        return result;
    }
}

