/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.collect.Sets;
import java.util.Set;

final class ManagedModelMergingStrategy {
    ManagedModelMergingStrategy() {
    }

    public static <T> Result<T> calculate(Set<T> current, Set<T> model, Set<T> managed) {
        Sets.SetView missing = Sets.difference(current, model);
        Sets.SetView removed = Sets.intersection((Set)missing, managed);
        Sets.SetView notRemoved = Sets.difference((Set)missing, (Set)removed);
        Sets.SetView added = Sets.difference(model, current);
        Sets.SetView nextElements = Sets.union(model, (Set)notRemoved);
        Sets.SetView nextManaged = Sets.difference((Set)Sets.union(managed, (Set)added), (Set)removed);
        return new Result(nextElements, nextManaged);
    }

    static class Result<T> {
        private final Set<T> nextElements;
        private final Set<T> newManaged;

        public Result(Set<T> nextElements, Set<T> nextManaged) {
            this.nextElements = nextElements;
            this.newManaged = nextManaged;
        }

        public Set<T> getNextElements() {
            return this.nextElements;
        }

        public Set<T> getNextManaged() {
            return this.newManaged;
        }
    }
}

