/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class BreakpointHitCountAction
extends ObjectActionDelegate {
    private static final String INITIAL_VALUE = "1";

    /*
     * Unable to fully structure code
     */
    public void run(IAction action) {
        selection = this.getCurrentSelection();
        if (selection == null) {
            return;
        }
        itr = selection.iterator();
        if (itr.hasNext()) ** GOTO lbl18
        return;
lbl-1000:
        // 1 sources

        {
            breakpoint = (IJavaBreakpoint)itr.next();
            try {
                oldHitCount = breakpoint.getHitCount();
                newHitCount = this.hitCountDialog(breakpoint);
                if (newHitCount == -1) continue;
                if (oldHitCount == newHitCount && newHitCount == 0) {
                    return;
                }
                breakpoint.setHitCount(newHitCount);
                continue;
            }
            catch (CoreException ce) {
                JDIDebugUIPlugin.statusDialog(ce.getStatus());
            }
lbl18:
            // 4 sources

            ** while (itr.hasNext())
        }
lbl19:
        // 1 sources

    }

    protected int hitCountDialog(IJavaBreakpoint breakpoint) {
        String title = ActionMessages.BreakpointHitCountAction_Set_Breakpoint_Hit_Count_2;
        String message = ActionMessages.BreakpointHitCountAction__Enter_the_new_hit_count_for_the_breakpoint__3;
        IInputValidator validator = new IInputValidator(){
            int hitCount = -1;

            public String isValid(String value) {
                try {
                    this.hitCount = Integer.parseInt(value.trim());
                }
                catch (NumberFormatException nfe) {
                    this.hitCount = -1;
                }
                if (this.hitCount < 1) {
                    return ActionMessages.BreakpointHitCountAction_Value_must_be_positive_integer;
                }
                return null;
            }
        };
        int currentHitCount = 0;
        try {
            currentHitCount = breakpoint.getHitCount();
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        String initialValue = currentHitCount > 0 ? Integer.toString(currentHitCount) : INITIAL_VALUE;
        Shell activeShell = JDIDebugUIPlugin.getActiveWorkbenchShell();
        HitCountDialog dialog = new HitCountDialog(activeShell, title, message, initialValue, validator);
        if (dialog.open() != 0) {
            return -1;
        }
        if (dialog.isHitCountEnabled()) {
            return Integer.parseInt(dialog.getValue().trim());
        }
        return 0;
    }

    class HitCountDialog
    extends InputDialog {
        private boolean fHitCountEnabled;

        protected HitCountDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
            super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
        }

        protected Control createDialogArea(Composite parent) {
            Composite area = (Composite)super.createDialogArea(parent);
            final Button checkbox = new Button(area, 32);
            GridData data = new GridData(768);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            checkbox.setLayoutData((Object)data);
            checkbox.setFont(parent.getFont());
            checkbox.setText(ActionMessages.BreakpointHitCountAction_Enable_Hit_Count_1);
            checkbox.setSelection(true);
            this.fHitCountEnabled = true;
            checkbox.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    HitCountDialog.this.fHitCountEnabled = checkbox.getSelection();
                    HitCountDialog.this.getText().setEnabled(HitCountDialog.this.fHitCountEnabled);
                    if (HitCountDialog.this.fHitCountEnabled) {
                        HitCountDialog.this.validateInput();
                    } else {
                        HitCountDialog.this.setErrorMessage(null);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return area;
        }

        protected boolean isHitCountEnabled() {
            return this.fHitCountEnabled;
        }
    }
}

