/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.mapping;

import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCache;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCacheFile;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCacheTree;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelWorkingFile;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelWorkingTree;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;

public class GitChangeSetDropAdapterAssistant
extends CommonDropAdapterAssistant {
    private static final URLTransfer SELECTION_TRANSFER = URLTransfer.getInstance();
    private static final String STAGE_OP = "STAGE";
    private static final String UNSTAGE_OP = "UNSTAGE";
    private static final String UNSUPPORTED_OP = "UNSUPPORTED";

    public IStatus validateDrop(Object target, int operationCode, TransferData transferType) {
        TreeSelection selection = (TreeSelection)LocalSelectionTransfer.getTransfer().getSelection();
        String operation = this.getOperationType(selection);
        if (!UNSUPPORTED_OP.equals(operation) && (target instanceof GitModelWorkingTree ? UNSTAGE_OP.equals(operation) : STAGE_OP.equals(operation) && target instanceof GitModelCache)) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        TreeSelection selection = (TreeSelection)LocalSelectionTransfer.getTransfer().getSelection();
        String operation = this.getOperationType(selection);
        if (STAGE_OP.equals(operation)) {
            CommonUtils.runCommand("org.eclipse.egit.ui.team.AddToIndex", (IStructuredSelection)selection);
        } else if (UNSTAGE_OP.equals(operation)) {
            CommonUtils.runCommand("org.eclipse.egit.ui.team.RemoveFromIndex", (IStructuredSelection)selection);
        }
        return Status.OK_STATUS;
    }

    public boolean isSupportedType(TransferData aTransferType) {
        return SELECTION_TRANSFER.isSupportedType(aTransferType);
    }

    private String getOperationType(TreeSelection selection) {
        String operation = null;
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            String tmpOperation = null;
            Object next = i.next();
            if (next instanceof GitModelWorkingFile) {
                tmpOperation = STAGE_OP;
            } else if (next instanceof GitModelCacheFile) {
                tmpOperation = UNSTAGE_OP;
            } else if (next instanceof GitModelCacheTree) {
                tmpOperation = ((GitModelCacheTree)((Object)next)).isWorkingTree() ? STAGE_OP : UNSTAGE_OP;
            } else {
                operation = UNSUPPORTED_OP;
                break;
            }
            if (operation == null) {
                operation = tmpOperation;
                continue;
            }
            if (operation.equals(tmpOperation)) continue;
            operation = UNSUPPORTED_OP;
            break;
        }
        return operation;
    }
}

