/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.model.js;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.scout.sdk.core.s.model.js.IScoutJsElement;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsModel;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsModels;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeModule;
import org.eclipse.scout.sdk.core.util.Ensure;

public class ScoutJsElementSpliterator<E extends IScoutJsElement>
implements Spliterator<E> {
    private final Function<ScoutJsModel, Collection<E>> m_scoutElementsProvider;
    private final Deque<INodeModule> m_dependencyDek;
    private final int m_characteristics;
    private final IES6Class m_widgetClass;
    private Iterator<E> m_currentModelElementsIterator;

    public ScoutJsElementSpliterator(ScoutJsModel start, boolean includeStart, boolean includeDependencies, Function<ScoutJsModel, Collection<E>> scoutElementsProvider) {
        this.m_scoutElementsProvider = (Function)Ensure.notNull(scoutElementsProvider);
        this.m_widgetClass = start.widgetClass();
        this.m_dependencyDek = includeDependencies ? (Deque<Object>)start.scoutJsDependenciesRecursively().collect(Collectors.toCollection(ArrayDeque::new)) : new ArrayDeque<INodeModule>();
        if (includeStart) {
            this.m_dependencyDek.addLast(start.nodeModule());
        }
        this.moveToNextModel();
        if (this.m_currentModelElementsIterator == null) {
            this.m_currentModelElementsIterator = Collections.emptyIterator();
        }
        this.m_characteristics = 1296;
    }

    @Override
    public boolean tryAdvance(Consumer<? super E> consumer) {
        if (!this.m_currentModelElementsIterator.hasNext()) {
            boolean movedToNextModel;
            while ((movedToNextModel = this.moveToNextModel()) && !this.m_currentModelElementsIterator.hasNext()) {
            }
            if (!movedToNextModel) {
                return false;
            }
        }
        consumer.accept(this.m_currentModelElementsIterator.next());
        return true;
    }

    protected boolean moveToNextModel() {
        if (this.m_dependencyDek.isEmpty()) {
            this.m_currentModelElementsIterator = null;
            return false;
        }
        ScoutJsModel currentModel = ScoutJsModels.create(this.m_dependencyDek.removeLast(), this.m_widgetClass).orElseThrow();
        this.m_currentModelElementsIterator = this.m_scoutElementsProvider.apply(currentModel).iterator();
        return true;
    }

    @Override
    public Spliterator<E> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return this.m_characteristics;
    }
}

