/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.schema.catalog;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.json.core.JSONCorePlugin;
import org.eclipse.wst.json.core.internal.JSONCoreMessages;
import org.eclipse.wst.json.core.internal.Logger;
import org.eclipse.wst.json.core.schema.catalog.ICatalog;
import org.eclipse.wst.json.core.schema.catalog.ICatalogElement;
import org.eclipse.wst.json.core.schema.catalog.ICatalogEntry;
import org.osgi.framework.Bundle;

public class CatalogContributorRegistryReader {
    protected static final String EXTENSION_POINT_ID = "schemaCatalogContributions";
    protected static final String TAG_CONTRIBUTION = "schemaCatalogContribution";
    protected ICatalog catalog;
    protected String declaringExtensionId;

    protected CatalogContributorRegistryReader(ICatalog catalog) {
        this.catalog = catalog;
    }

    protected void readRegistry() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = pluginRegistry.getExtensionPoint(JSONCorePlugin.getDefault().getBundle().getSymbolicName(), EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.readElement(elements[i]);
                ++i;
            }
        }
    }

    public static String resolvePath(URL platformURL, String path) {
        String fileLocation = path;
        int jarPathStart = path.indexOf("jar:");
        jarPathStart = jarPathStart < 0 ? 0 : jarPathStart + "jar:".length();
        int jarPathEnd = path.indexOf("!");
        jarPathEnd = jarPathEnd < 0 ? path.length() : jarPathEnd;
        fileLocation = path.substring(jarPathStart, jarPathEnd);
        String result = path;
        String resolvedLocation = fileLocation;
        URL resolvedURL = null;
        if (fileLocation.startsWith("platform:/plugin")) {
            try {
                resolvedURL = Platform.resolve((URL)new URL(fileLocation));
            }
            catch (IOException iOException) {}
        } else {
            try {
                resolvedURL = new URL(Platform.resolve((URL)platformURL), fileLocation);
            }
            catch (IOException iOException) {}
        }
        if (resolvedURL != null) {
            resolvedLocation = resolvedURL.toExternalForm().replace('\\', '/');
            result = result.replaceFirst(fileLocation, resolvedLocation);
        }
        return result;
    }

    public static URL getPlatformURL(String pluginId) {
        URL bundleEntry;
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null && (bundleEntry = bundle.getEntry("/")) != null) {
            try {
                return Platform.resolve((URL)bundleEntry);
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
        return null;
    }

    private String resolvePath(String path) {
        return CatalogContributorRegistryReader.resolvePath(CatalogContributorRegistryReader.getPlatformURL(this.declaringExtensionId), path);
    }

    protected void readElement(IConfigurationElement element) {
        try {
            this.declaringExtensionId = element.getDeclaringExtension().getNamespace();
        }
        catch (InvalidRegistryObjectException e) {
            Logger.logException(e);
        }
        if (TAG_CONTRIBUTION.equals(element.getName())) {
            IConfigurationElement[] mappingInfoElementList = element.getChildren("schema");
            this.processMappingInfoElements(mappingInfoElementList);
        }
    }

    private void processMappingInfoElements(IConfigurationElement[] childElementList) {
        if (this.catalog == null) {
            return;
        }
        int i = 0;
        while (i < childElementList.length) {
            String entryURI;
            IConfigurationElement childElement = childElementList[i];
            String name = childElement.getName();
            int type = 2;
            String fileMatch = null;
            if ("schema".equals(name)) {
                fileMatch = childElement.getAttribute("fileMatch");
            }
            if ((entryURI = childElement.getAttribute("uri")) == null || entryURI.equals("")) {
                Logger.log(4, JSONCoreMessages.Catalog_entry_uri_not_set);
            } else {
                ICatalogElement catalogElement = this.catalog.createCatalogElement(type);
                if (catalogElement instanceof ICatalogEntry) {
                    ICatalogEntry entry = (ICatalogEntry)catalogElement;
                    entry.setKey(fileMatch);
                    String resolvedPath = this.resolvePath(entryURI);
                    entry.setURI(resolvedPath);
                    String id = childElement.getAttribute("name");
                    if (id != null && !id.equals("")) {
                        entry.setId(id);
                    }
                }
                int j = 0;
                while (j < childElement.getAttributeNames().length) {
                    String cfr_ignored_0 = childElement.getAttributeNames()[j];
                    ++j;
                }
                this.catalog.addCatalogElement(catalogElement);
            }
            ++i;
        }
    }
}

