/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.Target;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.xml.sax.SAXException;

public class MethodTarget
implements Target {
    protected static Log log = LogFactory.getLog(MethodTarget.class.getName());
    private Object targetObject;
    private Method targetMethod;
    private static final Class[] objArg = new Class[]{Object.class};

    public MethodTarget(Object targetObject, Method targetMethod) {
        this.targetObject = targetObject;
        this.targetMethod = targetMethod;
    }

    public MethodTarget(Object targetObject, String methodName) throws NoSuchMethodException {
        this.targetObject = targetObject;
        Class<?> cls = targetObject.getClass();
        this.targetMethod = cls.getMethod(methodName, objArg);
    }

    public void set(Object value) throws SAXException {
        try {
            this.targetMethod.invoke(this.targetObject, value);
        }
        catch (IllegalAccessException accEx) {
            log.error((Object)Messages.getMessage("illegalAccessException00"), (Throwable)accEx);
            throw new SAXException(accEx);
        }
        catch (IllegalArgumentException argEx) {
            log.error((Object)Messages.getMessage("illegalArgumentException00"), (Throwable)argEx);
            throw new SAXException(argEx);
        }
        catch (InvocationTargetException targetEx) {
            log.error((Object)Messages.getMessage("invocationTargetException00"), (Throwable)targetEx);
            throw new SAXException(targetEx);
        }
    }
}

