/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.tools.ant.wsdl;

import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.axis.constants.Scope;
import org.apache.axis.tools.ant.wsdl.MappingSet;
import org.apache.axis.tools.ant.wsdl.NamespaceMapping;
import org.apache.axis.tools.ant.wsdl.TypeMappingVersionEnum;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.DefaultAuthenticator;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.FactoryProperty;
import org.apache.axis.wsdl.toJava.NamespaceSelector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;

public class Wsdl2javaAntTask
extends Task {
    private boolean verbose = false;
    private boolean debug = false;
    private boolean quiet = false;
    private boolean server = false;
    private boolean skeletonDeploy = false;
    private boolean testCase = false;
    private boolean noImports = false;
    private boolean all = false;
    private boolean helperGen = false;
    private boolean noWrapped = false;
    private boolean allowInvalidURL = false;
    private String factory = null;
    private HashMap namespaceMap = new HashMap();
    private String output = ".";
    private String protocolHandlerPkgs = "";
    private String deployScope = "";
    private String url = "";
    private String typeMappingVersion = "1.2";
    private long timeout = 45000L;
    private File namespaceMappingFile = null;
    private MappingSet mappings = new MappingSet();
    private String username = null;
    private String password = null;
    private Path classpath = null;
    private List nsIncludes = new ArrayList();
    private List nsExcludes = new ArrayList();
    private List properties = new ArrayList();
    private String implementationClassName = null;
    private CommandlineJava commandline = new CommandlineJava();
    private boolean printStackTraceOnFailure = true;
    private boolean failOnNetworkErrors = false;
    private boolean wrapArrays = false;

    protected void validate() throws BuildException {
        if (this.url == null || this.url.length() == 0) {
            throw new BuildException("No url specified");
        }
        if (this.timeout < -1L) {
            throw new BuildException("negative timeout supplied");
        }
        File outdir = new File(this.output);
        if (!outdir.isDirectory() || !outdir.exists()) {
            throw new BuildException("output directory is not valid");
        }
        if (this.quiet) {
            if (this.verbose) {
                throw new BuildException("quiet and verbose options are exclusive");
            }
            if (this.debug) {
                throw new BuildException("quiet and debug options are exclusive");
            }
        }
    }

    public void traceParams(int logLevel) {
        this.log("Running Wsdl2javaAntTask with parameters:", logLevel);
        this.log("\tverbose:" + this.verbose, logLevel);
        this.log("\tdebug:" + this.debug, logLevel);
        this.log("\tquiet:" + this.quiet, logLevel);
        this.log("\tserver-side:" + this.server, logLevel);
        this.log("\tskeletonDeploy:" + this.skeletonDeploy, logLevel);
        this.log("\thelperGen:" + this.helperGen, logLevel);
        this.log("\tfactory:" + this.factory, logLevel);
        this.log("\tnsIncludes:" + this.nsIncludes, logLevel);
        this.log("\tnsExcludes:" + this.nsExcludes, logLevel);
        this.log("\tfactoryProps:" + this.properties, logLevel);
        this.log("\ttestCase:" + this.testCase, logLevel);
        this.log("\tnoImports:" + this.noImports, logLevel);
        this.log("\tNStoPkg:" + this.namespaceMap, logLevel);
        this.log("\toutput:" + this.output, logLevel);
        this.log("\tprotocolHandlerPkgs:" + this.protocolHandlerPkgs, logLevel);
        this.log("\tdeployScope:" + this.deployScope, logLevel);
        this.log("\tURL:" + this.url, logLevel);
        this.log("\tall:" + this.all, logLevel);
        this.log("\ttypeMappingVersion:" + this.typeMappingVersion, logLevel);
        this.log("\ttimeout:" + this.timeout, logLevel);
        this.log("\tfailOnNetworkErrors:" + this.failOnNetworkErrors, logLevel);
        this.log("\tprintStackTraceOnFailure:" + this.printStackTraceOnFailure, logLevel);
        this.log("\tnamespaceMappingFile:" + this.namespaceMappingFile, logLevel);
        this.log("\tusername:" + this.username, logLevel);
        this.log("\t:password" + this.password, logLevel);
        this.log("\t:noWrapped" + this.noWrapped, logLevel);
        this.log("\t:allowInvalidURL" + this.allowInvalidURL, logLevel);
        this.log("\t:implementationClassName" + this.implementationClassName, logLevel);
        this.log("\t:classpath" + this.classpath, logLevel);
        this.traceNetworkSettings(logLevel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        this.traceParams(3);
        this.validate();
        CommandlineJava.SysProperties sysProperties = this.commandline.getSystemProperties();
        if (sysProperties != null) {
            sysProperties.setSystem();
        }
        try {
            Scope scope;
            Emitter emitter = this.createEmitter();
            if (this.classpath != null) {
                AntClassLoader cl = new AntClassLoader(((Object)((Object)this)).getClass().getClassLoader(), this.getProject(), this.classpath, true);
                this.log("Using CLASSPATH " + cl.getClasspath(), 3);
                ClassUtils.setDefaultClassLoader((ClassLoader)cl);
            }
            if ((scope = Scope.getScope((String)this.deployScope, null)) != null) {
                emitter.setScope(scope);
            } else if (this.deployScope.length() != 0 && !"none".equalsIgnoreCase(this.deployScope)) {
                this.log("Unrecognized scope:  " + this.deployScope + ".  Ignoring it.", 3);
            }
            this.mappings.execute((ProjectComponent)this, this.namespaceMap, false);
            if (!this.namespaceMap.isEmpty()) {
                emitter.setNamespaceMap(this.namespaceMap);
            }
            emitter.setTestCaseWanted(this.testCase);
            emitter.setHelperWanted(this.helperGen);
            if (this.factory != null) {
                emitter.setFactory(this.factory);
            }
            emitter.setNamespaceIncludes(this.nsIncludes);
            emitter.setNamespaceExcludes(this.nsExcludes);
            emitter.setProperties(this.properties);
            emitter.setImports(!this.noImports);
            emitter.setAllWanted(this.all);
            emitter.setOutputDir(this.output);
            emitter.setServerSide(this.server);
            emitter.setSkeletonWanted(this.skeletonDeploy);
            emitter.setVerbose(this.verbose);
            emitter.setDebug(this.debug);
            emitter.setQuiet(this.quiet);
            emitter.setTypeMappingVersion(this.typeMappingVersion);
            emitter.setNowrap(this.noWrapped);
            emitter.setAllowInvalidURL(this.allowInvalidURL);
            emitter.setWrapArrays(this.wrapArrays);
            if (this.namespaceMappingFile != null) {
                emitter.setNStoPkg(this.namespaceMappingFile.toString());
            }
            emitter.setTimeout(this.timeout);
            emitter.setImplementationClassName(this.implementationClassName);
            Authenticator.setDefault((Authenticator)new DefaultAuthenticator(this.username, this.password));
            try {
                if (this.url.indexOf(58) == -1) {
                    this.url = this.getProject().resolveFile(this.url).getAbsolutePath();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.log("WSDL2Java " + this.url, 2);
            try {
                emitter.run(this.url);
                return;
            }
            catch (Throwable e) {
                if (!this.url.startsWith("http://")) throw e;
                if (!this.failOnNetworkErrors) {
                    this.log(e.toString(), 1);
                    if (sysProperties == null) return;
                    sysProperties.restoreSystem();
                    return;
                }
                try {
                    throw new BuildException("Could not build " + this.url, e);
                }
                catch (BuildException b) {
                    throw b;
                }
                catch (Throwable t) {
                    if (!this.printStackTraceOnFailure) throw new BuildException("WSDL processing error for " + this.url + " :\n " + t.getMessage(), t);
                    this.traceParams(2);
                    t.printStackTrace();
                    throw new BuildException("WSDL processing error for " + this.url + " :\n " + t.getMessage(), t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (sysProperties != null) {
                sysProperties.restoreSystem();
            }
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setServerSide(boolean parameter) {
        this.server = parameter;
    }

    public void setSkeletonDeploy(boolean parameter) {
        this.skeletonDeploy = parameter;
    }

    public void setTestCase(boolean parameter) {
        this.testCase = parameter;
    }

    public void setHelperGen(boolean parameter) {
        this.helperGen = parameter;
    }

    public void setFactory(String parameter) {
        this.factory = parameter;
    }

    public void setNoImports(boolean parameter) {
        this.noImports = parameter;
    }

    public void setOutput(File parameter) throws BuildException {
        try {
            this.output = parameter.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
    }

    public void setProtocolHandlerPkgs(String handlerPkgs) {
        String currentPkgs = System.getProperty("java.protocol.handler.pkgs");
        String newPkgs = null;
        newPkgs = currentPkgs == null ? handlerPkgs : currentPkgs + "|" + handlerPkgs;
        System.setProperty("java.protocol.handler.pkgs", newPkgs);
    }

    public void setDeployScope(String scope) {
        this.deployScope = scope;
    }

    public void setURL(String parameter) {
        this.url = parameter;
    }

    public void setAll(boolean parameter) {
        this.all = parameter;
    }

    public void setTypeMappingVersion(TypeMappingVersionEnum parameter) {
        this.typeMappingVersion = parameter.getValue();
    }

    public void setTimeout(long parameter) {
        this.timeout = parameter;
    }

    public void addMapping(NamespaceMapping mapping) {
        this.mappings.addMapping(mapping);
    }

    public void addMappingSet(MappingSet mappingset) {
        this.mappings.addMappingSet(mappingset);
    }

    public void setNamespaceMappingFile(File namespaceMappingFile) {
        this.namespaceMappingFile = namespaceMappingFile;
    }

    public void setFailOnNetworkErrors(boolean failOnNetworkErrors) {
        this.failOnNetworkErrors = failOnNetworkErrors;
    }

    public void setPrintStackTraceOnFailure(boolean printStackTraceOnFailure) {
        this.printStackTraceOnFailure = printStackTraceOnFailure;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setNoWrapped(boolean noWrapped) {
        this.noWrapped = noWrapped;
    }

    public void setAllowInvalidUrl(boolean b) {
        this.allowInvalidURL = b;
    }

    public void setImplementationClassName(String implementationClassName) {
        this.implementationClassName = implementationClassName;
    }

    public void setWrapArrays(boolean wrapArrays) {
        this.wrapArrays = wrapArrays;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public NamespaceSelector createNsInclude() {
        NamespaceSelector selector = new NamespaceSelector();
        this.nsIncludes.add(selector);
        return selector;
    }

    public NamespaceSelector createNsExclude() {
        NamespaceSelector selector = new NamespaceSelector();
        this.nsExcludes.add(selector);
        return selector;
    }

    public FactoryProperty createProperty() {
        FactoryProperty property = new FactoryProperty();
        this.properties.add(property);
        return property;
    }

    protected Emitter createEmitter() {
        return new Emitter();
    }

    protected NamespaceSelector createSelector() {
        return new NamespaceSelector();
    }

    private void traceSystemSetting(String setting, int logLevel) {
        String value = System.getProperty(setting);
        this.log("\t" + setting + "=" + value, logLevel);
    }

    private void traceNetworkSettings(int logLevel) {
        this.traceSystemSetting("http.proxyHost", logLevel);
        this.traceSystemSetting("http.proxyPort", logLevel);
        this.traceSystemSetting("http.proxyUser", logLevel);
        this.traceSystemSetting("http.proxyPassword", logLevel);
        this.traceSystemSetting("socks.proxyHost", logLevel);
        this.traceSystemSetting("socks.proxyPort", logLevel);
    }

    public void addSysproperty(Environment.Variable sysp) {
        this.commandline.addSysproperty(sysp);
    }
}

