/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.generator;

import java.util.Optional;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.typescript.builder.ITypeScriptSourceBuilder;
import org.eclipse.scout.sdk.core.typescript.builder.TypeScriptSourceBuilder;
import org.eclipse.scout.sdk.core.typescript.generator.ITypeScriptElementGenerator;
import org.eclipse.scout.sdk.core.util.Strings;

public abstract class AbstractTypeScriptElementGenerator<TYPE extends ITypeScriptElementGenerator<TYPE>>
implements ITypeScriptElementGenerator<TYPE> {
    private String m_elementName;
    private boolean m_setupDone;

    protected AbstractTypeScriptElementGenerator() {
    }

    protected TYPE thisInstance() {
        return (TYPE)this;
    }

    @Override
    public Optional<String> elementName() {
        return Strings.notBlank((CharSequence)this.m_elementName);
    }

    @Override
    public TYPE withElementName(String newName) {
        this.m_elementName = newName;
        return this.thisInstance();
    }

    protected void setup() {
    }

    protected void build(ITypeScriptSourceBuilder<?> builder) {
    }

    public static ITypeScriptSourceBuilder<?> ensureTypeScriptSourceBuilder(ISourceBuilder<?> inner) {
        if (inner instanceof ITypeScriptSourceBuilder) {
            ITypeScriptSourceBuilder tsBuilder = (ITypeScriptSourceBuilder)inner;
            return tsBuilder;
        }
        return TypeScriptSourceBuilder.create(inner);
    }

    public final void generate(ISourceBuilder<?> builder) {
        if (!this.isSetupDone()) {
            this.setup();
            this.setSetupDone();
        }
        ITypeScriptSourceBuilder<?> typeScriptBuilder = AbstractTypeScriptElementGenerator.ensureTypeScriptSourceBuilder(builder);
        this.elementName().ifPresent(n -> typeScriptBuilder.context().importValidator().importCollector().registerReservedName((String)n));
        this.build(typeScriptBuilder);
    }

    private boolean isSetupDone() {
        return this.m_setupDone;
    }

    private void setSetupDone() {
        this.m_setupDone = true;
    }
}

