/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.favorites.actions;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.wst.ws.internal.explorer.platform.actions.LinkAction;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.ITransformer;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.MassNodeIdTransformer;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;

public abstract class MultipleLinkAction
extends LinkAction {
    public MultipleLinkAction(Controller controller) {
        super(controller);
    }

    @Override
    protected boolean processLinkParameters(HttpServletRequest request) {
        String isMultipleLinkAction = request.getParameter("multipleLinkAction");
        if (isMultipleLinkAction != null) {
            this.propertyTable_.put("multipleLinkAction", isMultipleLinkAction);
            return this.processMultipleLinkActionParameters(request);
        }
        this.propertyTable_.remove("multipleLinkAction");
        String nodeIDString = request.getParameter("nodeId");
        String toolIDString = request.getParameter("toolId");
        String viewIDString = request.getParameter("viewId");
        String viewToolIDString = request.getParameter("viewToolId");
        if (nodeIDString != null) {
            this.propertyTable_.put("nodeId", nodeIDString);
        }
        if (toolIDString != null) {
            this.propertyTable_.put("toolId", toolIDString);
        }
        if (viewIDString != null) {
            this.propertyTable_.put("viewId", viewIDString);
        }
        if (viewToolIDString != null) {
            this.propertyTable_.put("viewToolId", viewToolIDString);
        }
        return true;
    }

    protected boolean processMultipleLinkActionParameters(HttpServletRequest request) {
        String[] massActionNodeIDs = request.getParameterValues("massActionNodeID");
        this.propertyTable_.put("massActionNodeID", massActionNodeIDs);
        return massActionNodeIDs.length != 0;
    }

    @Override
    public ITransformer[] getTransformers() {
        return new ITransformer[]{new MassNodeIdTransformer(this.controller_, "massActionNodeID")};
    }

    protected boolean isMultipleLinkAction() {
        return this.propertyTable_.containsKey("multipleLinkAction");
    }

    protected String[] getMassActionNodeIds() {
        Object object = this.propertyTable_.get("massActionNodeID");
        if (object == null) {
            return new String[0];
        }
        if (object.getClass().isArray()) {
            return (String[])object;
        }
        return new String[]{(String)object};
    }

    @Override
    public boolean run() {
        return this.isMultipleLinkAction() ? this.executeMultipleLinkAction() : this.executeSingleLinkAction();
    }

    protected boolean executeMultipleLinkAction() {
        boolean result = false;
        String[] massActionNodeIDs = this.getMassActionNodeIds();
        if (massActionNodeIDs != null) {
            int i = 0;
            while (i < massActionNodeIDs.length) {
                this.propertyTable_.put("nodeId", massActionNodeIDs[i]);
                if (this.executeSingleLinkAction()) {
                    result = true;
                }
                ++i;
            }
            this.propertyTable_.remove("nodeId");
        }
        return result;
    }

    protected abstract boolean executeSingleLinkAction();
}

